/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Comparator;
import java.util.Random;
import org.ddogleg.sorting.QuickSortComparator;
import org.junit.Assert;
import org.junit.Test;

public class TestQuickSortComparator_F64 {
    Random rand = new Random(1044180L);
    Comparator<Double> comparator = new Comparator<Double>(){

        @Override
        public int compare(Double o1, Double o2) {
            if (o1 > o2) {
                return 1;
            }
            if (o1 < o2) {
                return -1;
            }
            return 0;
        }
    };

    @Test
    public void testSortingRandom() {
        Double[] ret = TestQuickSortComparator_F64.createRandom(this.rand, 200);
        double preTotal = TestQuickSortComparator_F64.sum(ret);
        QuickSortComparator<Double> sorter = new QuickSortComparator<Double>(this.comparator);
        sorter.sort((Double[])ret, ret.length);
        double postTotal = TestQuickSortComparator_F64.sum(ret);
        Assert.assertEquals((double)preTotal, (double)postTotal, (double)1.0E-8);
        double prev = ret[0];
        for (int i = 1; i < ret.length; ++i) {
            if (ret[i] < prev) {
                Assert.fail((String)"Not ascending");
            }
            prev = ret[i];
        }
    }

    @Test
    public void testSortingRandom_indexes() {
        for (int a = 0; a < 20; ++a) {
            Double[] normal = TestQuickSortComparator_F64.createRandom(this.rand, 20);
            Double[] original = (Double[])normal.clone();
            Double[] withIndexes = (Double[])normal.clone();
            int[] indexes = new int[normal.length];
            QuickSortComparator<Double> sorter = new QuickSortComparator<Double>(this.comparator);
            sorter.sort((Double[])normal, normal.length);
            sorter.sort((Double[])withIndexes, normal.length, indexes);
            for (int i = 0; i < normal.length; ++i) {
                Assert.assertEquals((double)original[i], (double)withIndexes[i], (double)1.0E-8);
                Assert.assertEquals((double)normal[i], (double)withIndexes[indexes[i]], (double)1.0E-8);
            }
        }
    }

    public static double sum(Double[] list) {
        double total = 0.0;
        for (int i = 0; i < list.length; ++i) {
            total += list[i].doubleValue();
        }
        return total;
    }

    public static Double[] createRandom(Random rand, int num) {
        Double[] ret = new Double[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (rand.nextDouble() - 0.5) * 2000.0;
        }
        return ret;
    }
}

