/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.ApproximateSort_F64;
import org.ddogleg.sorting.SortableParameter_F64;
import org.junit.Assert;
import org.junit.Test;

public class TestApproximateSort_F64 {
    Random rand = new Random(234L);

    @Test
    public void computeRange_primitive() {
        ApproximateSort_F64 alg = new ApproximateSort_F64(12);
        double[] data = this.random(-5.0, 10.0, 4, 200);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 4; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        alg.computeRange(data, 4, 200);
        Assert.assertEquals((double)min, (double)alg.minValue, (double)1.0E-8);
        Assert.assertEquals((double)max, (double)alg.maxValue, (double)1.0E-8);
    }

    @Test
    public void computeRange_object() {
        ApproximateSort_F64 alg = new ApproximateSort_F64(12);
        double[] data = this.random(-5.0, 10.0, 4, 200);
        SortableParameter_F64[] objs = this.convert(data);
        double min = Double.MAX_VALUE;
        double max = -1.7976931348623157E308;
        for (int i = 4; i < data.length; ++i) {
            if (data[i] < min) {
                min = data[i];
            }
            if (!(data[i] > max)) continue;
            max = data[i];
        }
        alg.computeRange(objs, 4, 200);
        Assert.assertEquals((double)min, (double)alg.minValue, (double)1.0E-8);
        Assert.assertEquals((double)max, (double)alg.maxValue, (double)1.0E-8);
    }

    @Test
    public void sortIndex() {
        int i;
        int numBins = 150;
        double tolerance = 15.0 / (double)numBins;
        double[] data = this.random(-5.0, 10.0, 4, 200);
        int[] indexes = new int[200];
        ApproximateSort_F64 alg = new ApproximateSort_F64(-5.0, 10.0, numBins);
        alg.sortIndex(data, 4, 200, indexes);
        boolean[] used = new boolean[indexes.length];
        used[indexes[0] - 4] = true;
        for (i = 1; i < indexes.length; ++i) {
            used[indexes[i] - 4] = true;
            Assert.assertTrue((data[indexes[i]] > data[indexes[i - 1]] - tolerance ? 1 : 0) != 0);
        }
        for (i = 0; i < indexes.length; ++i) {
            Assert.assertTrue((boolean)used[i]);
        }
    }

    @Test
    public void sortObject() {
        int numBins = 150;
        double tolerance = 15.0 / (double)numBins;
        double[] data = this.random(-5.0, 10.0, 4, 200);
        SortableParameter_F64[] objs = this.convert(data);
        ApproximateSort_F64 alg = new ApproximateSort_F64(-5.0, 10.0, numBins);
        alg.sortObject(objs, 4, 200);
        for (int i = 5; i < objs.length; ++i) {
            Assert.assertTrue((objs[i].sortValue > objs[i - 1].sortValue - tolerance ? 1 : 0) != 0);
        }
    }

    public double[] random(double min, double max, int offset, int total) {
        double[] ret = new double[offset + total];
        double range = max - min;
        for (int i = 0; i < total; ++i) {
            ret[i + offset] = this.rand.nextDouble() * range + min;
        }
        return ret;
    }

    public SortableParameter_F64[] convert(double[] data) {
        SortableParameter_F64[] ret = new SortableParameter_F64[data.length];
        for (int i = 0; i < data.length; ++i) {
            ret[i] = new SortableParameter_F64(data[i]);
        }
        return ret;
    }
}

