/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Comparator;

public class QuickSortComparator<T> {
    private int M = 7;
    private int NSTACK;
    private int[] istack;
    Comparator<T> comparator;

    public QuickSortComparator(Comparator<T> comparator) {
        this(65, 7, comparator);
    }

    public QuickSortComparator(int NSTACK, int M, Comparator<T> comparator) {
        this.M = M;
        this.NSTACK = NSTACK;
        this.istack = new int[NSTACK];
        this.comparator = comparator;
    }

    public void sort(T[] arr, int length) {
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int i;
            T a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[j];
                    for (i = j - 1; i >= l && this.comparator.compare(arr[i], a) > 0; --i) {
                        arr[i + 1] = arr[i];
                    }
                    arr[i + 1] = a;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            T temp = arr[k];
            arr[k] = arr[l + 1];
            arr[l + 1] = temp;
            if (this.comparator.compare(arr[l], arr[ir]) > 0) {
                temp = arr[l];
                arr[l] = arr[ir];
                arr[ir] = temp;
            }
            if (this.comparator.compare(arr[l + 1], arr[ir]) > 0) {
                temp = arr[l + 1];
                arr[l + 1] = arr[ir];
                arr[ir] = temp;
            }
            if (this.comparator.compare(arr[l], arr[l + 1]) > 0) {
                temp = arr[l];
                arr[l] = arr[l + 1];
                arr[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[l + 1];
            while (true) {
                if (this.comparator.compare(arr[++i], a) < 0) {
                    continue;
                }
                while (this.comparator.compare(arr[--j], a) > 0) {
                }
                if (j < i) break;
                temp = arr[i];
                arr[i] = arr[j];
                arr[j] = temp;
            }
            arr[l + 1] = arr[j];
            arr[j] = a;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }

    public void sort(T[] arr, int length, int[] indexes) {
        int i;
        for (i = 0; i < length; ++i) {
            indexes[i] = i;
        }
        int jstack = -1;
        int l = 0;
        int ir = length - 1;
        while (true) {
            int temp;
            T a;
            int j;
            if (ir - l < this.M) {
                for (j = l + 1; j <= ir; ++j) {
                    a = arr[indexes[j]];
                    temp = indexes[j];
                    for (i = j - 1; i >= l && this.comparator.compare(arr[indexes[i]], a) > 0; --i) {
                        indexes[i + 1] = indexes[i];
                    }
                    indexes[i + 1] = temp;
                }
                if (jstack < 0) break;
                ir = this.istack[jstack--];
                l = this.istack[jstack--];
                continue;
            }
            int k = l + ir >>> 1;
            temp = indexes[k];
            indexes[k] = indexes[l + 1];
            indexes[l + 1] = temp;
            if (this.comparator.compare(arr[indexes[l]], arr[indexes[ir]]) > 0) {
                temp = indexes[l];
                indexes[l] = indexes[ir];
                indexes[ir] = temp;
            }
            if (this.comparator.compare(arr[indexes[l + 1]], arr[indexes[ir]]) > 0) {
                temp = indexes[l + 1];
                indexes[l + 1] = indexes[ir];
                indexes[ir] = temp;
            }
            if (this.comparator.compare(arr[indexes[l]], arr[indexes[l + 1]]) > 0) {
                temp = indexes[l];
                indexes[l] = indexes[l + 1];
                indexes[l + 1] = temp;
            }
            i = l + 1;
            j = ir;
            a = arr[indexes[l + 1]];
            while (true) {
                if (this.comparator.compare(arr[indexes[++i]], a) < 0) {
                    continue;
                }
                while (this.comparator.compare(arr[indexes[--j]], a) > 0) {
                }
                if (j < i) break;
                temp = indexes[i];
                indexes[i] = indexes[j];
                indexes[j] = temp;
            }
            temp = indexes[l + 1];
            indexes[l + 1] = indexes[j];
            indexes[j] = temp;
            if ((jstack += 2) >= this.NSTACK) {
                throw new RuntimeException("NSTACK too small");
            }
            if (ir - i + 1 >= j - l) {
                this.istack[jstack] = ir;
                this.istack[jstack - 1] = i;
                ir = j - 1;
                continue;
            }
            this.istack[jstack] = j - 1;
            this.istack[jstack - 1] = l;
            l = i;
        }
    }
}

