/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.sorting;

import java.util.Random;
import org.ddogleg.sorting.QuickSelect;

public class BenchMarkSelect {
    public void process(int num) {
        double[] data = BenchMarkSelect.createRandom(new Random(836L), num);
        Comparable[] compData = new Comparable[data.length];
        for (int i = 0; i < compData.length; ++i) {
            compData[i] = Double.valueOf(data[i]);
        }
        int[] indexes = new int[data.length];
        long before = System.currentTimeMillis();
        QuickSelect.select(data, 13, data.length);
        long after = System.currentTimeMillis();
        System.out.println("Select double = " + (after - before));
        data = BenchMarkSelect.createRandom(new Random(836L), num);
        before = System.currentTimeMillis();
        QuickSelect.selectIndex(data, 13, data.length, indexes);
        after = System.currentTimeMillis();
        System.out.println("Select double with indexes = " + (after - before));
        before = System.currentTimeMillis();
        QuickSelect.select(compData, 13, data.length);
        after = System.currentTimeMillis();
        System.out.println("Select comparable = " + (after - before));
    }

    public static double[] createRandom(Random rand, int num) {
        double[] ret = new double[num];
        for (int i = 0; i < num; ++i) {
            ret[i] = (rand.nextDouble() - 0.5) * 2000.0;
        }
        return ret;
    }

    public static void main(String[] args) {
        BenchMarkSelect bench = new BenchMarkSelect();
        bench.process(10000000);
    }
}

