/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver.impl;

import java.util.List;
import java.util.Random;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.ddogleg.solver.impl.RootFinderCompanion;
import org.ejml.data.Complex64F;
import org.junit.Assert;
import org.junit.Test;

public class TestRootFinderCompanion {
    Random rand = new Random(234L);

    @Test
    public void basicTest() {
        for (int numCoef = 2; numCoef < 6; ++numCoef) {
            Polynomial poly = new Polynomial(numCoef);
            for (int i = 0; i < numCoef; ++i) {
                poly.c[i] = 10.0 * (this.rand.nextDouble() - 0.5);
            }
            RootFinderCompanion alg = new RootFinderCompanion();
            Assert.assertTrue((boolean)alg.process(poly));
            List<Complex64F> roots = alg.getRoots();
            int numReal = 0;
            for (Complex64F c : roots) {
                if (!c.isReal()) continue;
                Assert.assertEquals((double)0.0, (double)poly.evaluate(c.real), (double)1.0E-8);
                ++numReal;
            }
            int expectedRoots = PolynomialOps.countRealRoots(poly);
            Assert.assertTrue((numReal == expectedRoots ? 1 : 0) != 0);
        }
    }
}

