/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.Random;
import org.ddogleg.solver.PolynomialSolver;
import org.ejml.data.Complex64F;
import org.junit.Assert;
import org.junit.Test;

public class TestPolynomialSolver {
    public static Random rand = new Random(234234L);

    @Test
    public void polynomialRootsEVD() {
        Complex64F[] roots = PolynomialSolver.polynomialRootsEVD(4.0, 3.0, 2.0, 1.0);
        int numReal = 0;
        for (Complex64F c : roots) {
            if (!c.isReal()) continue;
            Assert.assertEquals((double)0.0, (double)TestPolynomialSolver.cubic(4.0, 3.0, 2.0, 1.0, c.real), (double)1.0E-8);
            ++numReal;
        }
        Assert.assertTrue((numReal > 0 ? 1 : 0) != 0);
    }

    @Test
    public void cubicRootReal_known() {
        double root = PolynomialSolver.cubicRootReal(4.0, 3.0, 2.0, 1.0);
        Assert.assertEquals((double)-1.65062919143939, (double)root, (double)1.0E-8);
        Assert.assertEquals((double)0.0, (double)TestPolynomialSolver.cubic(4.0, 3.0, 2.0, 1.0, root), (double)1.0E-8);
    }

    @Test
    public void cubicRootReal_random() {
        for (int i = 0; i < 20; ++i) {
            double a = rand.nextGaussian() * 2.0;
            double b = rand.nextGaussian() * 2.0;
            double c = rand.nextGaussian() * 2.0;
            double d = rand.nextGaussian() * 2.0;
            double root = PolynomialSolver.cubicRootReal(a, b, c, d);
            Assert.assertEquals((double)0.0, (double)TestPolynomialSolver.cubic(a, b, c, d, root), (double)1.0E-8);
        }
    }

    public static double cubic(double a, double b, double c, double d, double x) {
        return d * x * x * x + c * x * x + b * x + a;
    }
}

