/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.solver;

import java.util.Random;
import org.ddogleg.solver.Polynomial;
import org.ddogleg.solver.PolynomialOps;
import org.junit.Assert;
import org.junit.Test;

public class TestPolynomialOps {
    Random rand = new Random(234L);

    @Test
    public void quadraticVertex() {
        double a = -0.5;
        double b = 2.0;
        double x = -b / (2.0 * a);
        double found = PolynomialOps.quadraticVertex(a, b);
        Assert.assertEquals((double)x, (double)found, (double)1.0E-8);
    }

    @Test
    public void derivative() {
        Polynomial p = Polynomial.wrap(2.0, 3.0, 4.0, 5.0);
        p.size = 2;
        Polynomial d = new Polynomial(10);
        PolynomialOps.derivative(p, d);
        Assert.assertTrue((boolean)d.isIdentical(Polynomial.wrap(3.0), 1.0E-8));
        p.size = 3;
        PolynomialOps.derivative(p, d);
        Assert.assertTrue((boolean)d.isIdentical(Polynomial.wrap(3.0, 8.0), 1.0E-8));
    }

    @Test
    public void refineRoot() {
    }

    @Test
    public void divide() {
        Polynomial n = Polynomial.wrap(1.0, 2.0, 3.0, 0.0);
        Polynomial d = Polynomial.wrap(-3.0, 1.0, 0.0);
        Polynomial q = new Polynomial(10);
        Polynomial r = new Polynomial(10);
        Polynomial expectedQ = Polynomial.wrap(11.0, 3.0, 0.0);
        Polynomial expectedR = Polynomial.wrap(34.0);
        PolynomialOps.divide(n, d, q, r);
        Assert.assertEquals((long)3L, (long)q.size);
        Assert.assertEquals((long)1L, (long)r.size);
        Assert.assertTrue((boolean)expectedQ.isIdentical(q, 1.0E-8));
        Assert.assertTrue((boolean)expectedR.isIdentical(r, 1.0E-8));
    }

    @Test
    public void multiply() {
        Polynomial a = PolynomialOps.multiply(Polynomial.wrap(2.0), Polynomial.wrap(3.0), null);
        Polynomial b = PolynomialOps.multiply(Polynomial.wrap(new double[0]), Polynomial.wrap(3.0), null);
        Polynomial c = PolynomialOps.multiply(Polynomial.wrap(new double[0]), Polynomial.wrap(new double[0]), null);
        Polynomial d = PolynomialOps.multiply(Polynomial.wrap(4.0), Polynomial.wrap(2.0, 3.0), null);
        Polynomial e = PolynomialOps.multiply(Polynomial.wrap(2.0, 3.0), Polynomial.wrap(4.0), null);
        Polynomial f = PolynomialOps.multiply(Polynomial.wrap(2.0, 3.0), Polynomial.wrap(4.0, 8.0), null);
        Assert.assertTrue((boolean)Polynomial.wrap(6.0).isIdentical(a, 1.0E-8));
        Assert.assertTrue((b.size == 0 ? 1 : 0) != 0);
        Assert.assertTrue((c.size == 0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)Polynomial.wrap(8.0, 12.0).isIdentical(d, 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(8.0, 12.0).isIdentical(e, 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(8.0, 28.0, 24.0).isIdentical(f, 1.0E-8));
    }

    @Test
    public void divide_then_multiply() {
        for (int i = 2; i < 10; ++i) {
            Polynomial n = this.createRandom(i);
            for (int j = 1; j < i; ++j) {
                Polynomial d = this.createRandom(j);
                Polynomial q = new Polynomial(10);
                Polynomial r = new Polynomial(10);
                PolynomialOps.divide(n, d, q, r);
                Polynomial a = PolynomialOps.multiply(d, q, null);
                Polynomial b = PolynomialOps.add(a, r, null);
                Assert.assertTrue((boolean)b.isIdentical(n, 1.0E-8));
            }
        }
    }

    @Test
    public void add() {
        Polynomial a = PolynomialOps.add(Polynomial.wrap(0.5, 1.0, 1.0), Polynomial.wrap(0.5, 1.0, 2.0), null);
        Polynomial b = PolynomialOps.add(Polynomial.wrap(0.5, 1.0), Polynomial.wrap(0.5, 1.0, 2.0), null);
        Polynomial c = PolynomialOps.add(Polynomial.wrap(0.5, 1.0, 1.0), Polynomial.wrap(0.5, 1.0), null);
        Assert.assertTrue((boolean)Polynomial.wrap(1.0, 2.0, 3.0).isIdentical(a, 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(1.0, 2.0, 2.0).isIdentical(b, 1.0E-8));
        Assert.assertTrue((boolean)Polynomial.wrap(1.0, 2.0, 1.0).isIdentical(c, 1.0E-8));
    }

    private Polynomial createRandom(int N) {
        Polynomial ret = new Polynomial(N);
        for (int i = 0; i < N; ++i) {
            ret.c[i] = 5.0 * (this.rand.nextDouble() - 0.5);
        }
        return ret;
    }

    @Test
    public void cubicRealRoot() {
        Polynomial p = Polynomial.wrap(4.0, -5.0, 2.0, 1.3);
        double root = PolynomialOps.cubicRealRoot(p.c[0], p.c[1], p.c[2], p.c[3]);
        double eval = p.evaluate(root);
        Assert.assertEquals((double)0.0, (double)eval, (double)1.0E-8);
    }
}

