/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.rand;

import java.util.Random;

public class UniformDraw {
    double min;
    double max;
    Random rand;

    public UniformDraw(Random rand, double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("max must be greater than or equal min");
        }
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            throw new IllegalArgumentException("Must be finite");
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            throw new IllegalArgumentException("Must not be NaN");
        }
        this.min = min;
        this.max = max;
        this.rand = rand;
    }

    public UniformDraw(double min, double max) {
        if (max < min) {
            throw new IllegalArgumentException("max must be greater than or equal min");
        }
        if (Double.isInfinite(min) || Double.isInfinite(max)) {
            throw new IllegalArgumentException("Must be finite");
        }
        if (Double.isNaN(min) || Double.isNaN(max)) {
            throw new IllegalArgumentException("Must not be NaN");
        }
        this.min = min;
        this.max = max;
    }

    public double getMin() {
        return this.min;
    }

    public void setRand(Random rand) {
        this.rand = rand;
    }

    public double getMax() {
        return this.max;
    }

    public double next() {
        return this.rand.nextDouble() * (this.max - this.min) + this.min;
    }

    public static double draw(Random rand, double min, double max) {
        return rand.nextDouble() * (max - min) + min;
    }
}

