/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.wrap;

import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.functions.GradientLineFunction;

public class CachedGradientLineFunction
implements GradientLineFunction {
    protected int N;
    protected double[] start;
    protected double[] direction;
    protected boolean cachedFunction;
    protected boolean cachedGradient;
    protected double[] currentInput;
    protected double[] currentGradient;
    protected double currentOutput;
    protected FunctionNtoS function;
    protected FunctionNtoN gradient;

    public CachedGradientLineFunction(FunctionNtoS function, FunctionNtoN gradient) {
        this.function = function;
        this.gradient = gradient;
        this.N = function.getNumOfInputsN();
        this.currentInput = new double[this.N];
        this.currentGradient = new double[this.N];
    }

    @Override
    public void setLine(double[] start, double[] direction) {
        this.start = start;
        this.direction = direction;
    }

    @Override
    public double[] getCurrentState() {
        return this.currentInput;
    }

    @Override
    public void setInput(double x) {
        for (int i = 0; i < this.N; ++i) {
            this.currentInput[i] = this.start[i] + x * this.direction[i];
        }
        this.cachedFunction = false;
        this.cachedGradient = false;
    }

    @Override
    public int getN() {
        return this.N;
    }

    @Override
    public void setInput(double[] x) {
        System.arraycopy(x, 0, this.currentInput, 0, this.N);
        this.cachedFunction = false;
        this.cachedGradient = false;
    }

    @Override
    public double computeFunction() {
        if (this.cachedFunction) {
            return this.currentOutput;
        }
        this.currentOutput = this.function.process(this.currentInput);
        this.cachedFunction = true;
        return this.currentOutput;
    }

    @Override
    public void computeGradient(double[] gradient) {
        if (!this.cachedGradient) {
            this.cachedGradient = true;
            this.gradient.process(this.currentInput, this.currentGradient);
        }
        System.arraycopy(this.currentGradient, 0, gradient, 0, this.N);
    }

    @Override
    public double computeDerivative() {
        if (!this.cachedGradient) {
            this.cachedGradient = true;
            this.gradient.process(this.currentInput, this.currentGradient);
        }
        double dot = 0.0;
        for (int i = 0; i < this.N; ++i) {
            dot += this.currentGradient[i] * this.direction[i];
        }
        return dot;
    }
}

