/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.EvaluateQuasiNewtonBFGS;
import org.ddogleg.optimization.NonlinearResults;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.impl.LineSearchMore94;
import org.ddogleg.optimization.impl.QuasiNewtonBFGS;
import org.ddogleg.optimization.impl.TrivialFunctionNtoS;
import org.ddogleg.optimization.wrap.CachedNumericalGradientLineFunction;
import org.junit.Assert;
import org.junit.Test;

public class TestQuasiNewtonBFGS {
    EvaluateQuasiNewtonBFGS evaluator = new EvaluateQuasiNewtonBFGS(false, false);

    @Test
    public void basicTest() {
        QuasiNewtonBFGS alg = this.createAlg(new TrivialFunctionNtoS());
        alg.initialize(new double[]{1.0, 1.0, 1.0});
        for (int i = 0; i < 200 && !alg.iterate(); ++i) {
        }
        Assert.assertTrue((boolean)alg.isConverged());
        double[] found = alg.getParameters();
        Assert.assertEquals((double)0.0, (double)found[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)found[1], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)found[2], (double)1.0E-4);
    }

    public QuasiNewtonBFGS createAlg(FunctionNtoS function) {
        double gtol = 0.9;
        LineSearchMore94 lineSearch = new LineSearchMore94().setConvergence(0.001, gtol, 0.1);
        CachedNumericalGradientLineFunction f = new CachedNumericalGradientLineFunction(function);
        QuasiNewtonBFGS alg = new QuasiNewtonBFGS(f, lineSearch, 0.0);
        alg.setConvergence(1.0E-7, 1.0E-7, gtol);
        return alg;
    }

    @Test
    public void powell() {
        NonlinearResults results = this.evaluator.powell();
        Assert.assertTrue((results.numFunction < 300 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 300 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }

    @Test
    public void helicalvalley() {
        NonlinearResults results = this.evaluator.helicalValley();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)results.x[0], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.x[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.x[2], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }

    @Test
    public void rosenbrock() {
        NonlinearResults results = this.evaluator.rosenbrock();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)1.0, (double)results.x[0], (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)results.x[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }

    @Test
    public void badlyScaledBrown() {
        NonlinearResults results = this.evaluator.badlyScaledBrown();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)1000000.0, (double)results.x[0], (double)1.0E-4);
        Assert.assertEquals((double)2.0E-6, (double)results.x[1], (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }

    @Test
    public void trigonometric() {
        NonlinearResults results = this.evaluator.trigonometric();
        Assert.assertTrue((results.numFunction < 100 ? 1 : 0) != 0);
        Assert.assertTrue((results.numGradient < 100 ? 1 : 0) != 0);
        Assert.assertEquals((double)0.0, (double)results.f, (double)1.0E-4);
    }
}

