/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.LineSearch;
import org.ddogleg.optimization.OptimizationException;
import org.ddogleg.optimization.functions.CoupledDerivative;
import org.ddogleg.optimization.impl.SearchInterpolate;

public class LineSearchMore94
implements LineSearch {
    private static final double p5 = 0.5;
    private static final double p66 = 0.66;
    private static final double xtrapl = 1.1;
    private static final double xtrapu = 4.0;
    private CoupledDerivative function;
    private double ftol = -1.0;
    private double gtol;
    private double xtol;
    private double finit;
    private double ginit;
    private double gtest;
    private double width;
    private double width1;
    private boolean bracket;
    private int stage;
    private double stx;
    private double fx;
    private double gx;
    private double sty;
    private double fy;
    private double gy;
    private double stmin;
    private double stmax;
    private double stp;
    private double fp;
    private double gp;
    private double stpmin;
    private double stpmax;
    private String message;
    private boolean firstIteration;
    private boolean converged;
    boolean updated;

    public LineSearchMore94 setConvergence(double ftol, double gtol, double xtol) {
        if (ftol < 0.0) {
            throw new IllegalArgumentException("ftol must be >= 0 ");
        }
        if (gtol < 0.0) {
            throw new IllegalArgumentException("gtol must be >= 0 ");
        }
        if (xtol < 0.0) {
            throw new IllegalArgumentException("xtol must be >= 0 ");
        }
        this.ftol = ftol;
        this.gtol = gtol;
        this.xtol = xtol;
        return this;
    }

    @Override
    public void setFunction(CoupledDerivative function) {
        this.function = function;
    }

    @Override
    public void init(double funcAtZero, double derivAtZero, double funcAtInit, double stepInit, double stepMin, double stepMax) {
        if (this.ftol < 0.0) {
            throw new IllegalArgumentException("Must call setParameters first before init");
        }
        if (stepMax < stepMin) {
            throw new IllegalArgumentException("stpmin must be < stpmax");
        }
        if (stepMin < 0.0) {
            throw new IllegalArgumentException("stpmin must be > 0");
        }
        if (stepInit < stepMin) {
            throw new IllegalArgumentException("Initial step is less than the minimum allowed step.");
        }
        if (stepInit > stepMax) {
            throw new IllegalArgumentException("Initial step is more than the maximum allowed step.");
        }
        if (derivAtZero >= 0.0) {
            throw new IllegalArgumentException("Initial derivative is >= 0");
        }
        this.stpmin = stepMin;
        this.stpmax = stepMax;
        this.bracket = false;
        this.stage = 0;
        this.finit = funcAtZero;
        this.ginit = derivAtZero;
        this.gtest = this.ftol * this.ginit;
        this.width = this.stpmax - this.stpmin;
        this.width1 = this.width / 0.5;
        this.stp = stepInit;
        this.fp = funcAtInit;
        this.stx = 0.0;
        this.fx = this.finit;
        this.gx = this.ginit;
        this.sty = 0.0;
        this.fy = this.finit;
        this.gy = this.ginit;
        this.stmin = 0.0;
        this.stmax = this.stp + 4.0 * this.stp;
        this.message = null;
        this.firstIteration = true;
        this.converged = false;
        this.updated = false;
    }

    @Override
    public boolean iterate() throws OptimizationException {
        this.function.setInput(this.stp);
        this.gp = this.function.computeDerivative();
        if (!this.firstIteration) {
            this.fp = this.function.computeFunction();
        } else {
            this.firstIteration = false;
        }
        double ftest = this.finit + this.stp * this.gtest;
        if (this.stage == 0 && this.fp <= ftest && this.gp >= 0.0) {
            this.stage = 1;
        }
        if (this.bracket && (this.stp <= this.stmin || this.stp >= this.stmax)) {
            this.message = "Rounding error preventing progress.";
        }
        if (this.bracket && this.stmax - this.stmin <= this.xtol * this.stmax) {
            this.converged = true;
            this.message = "XTOL test satisfied";
        }
        if (this.stp == this.stpmax && this.fp <= ftest && this.gp <= this.gtest) {
            this.message = "stp == stpmax";
        }
        if (this.stp == this.stpmin && (this.fp > ftest || this.gp >= this.gtest)) {
            this.message = "stp == stpmin";
        }
        if (this.fp <= ftest && Math.abs(this.gp) <= this.gtol * -this.ginit) {
            this.converged = true;
            return true;
        }
        if (this.message != null || this.converged) {
            return true;
        }
        if (this.stage == 0 && this.fp <= this.fx && this.fp > ftest) {
            this.fp -= this.stp * this.gtest;
            this.fx -= this.stx * this.gtest;
            this.fy -= this.sty * this.gtest;
            this.gp -= this.gtest;
            this.gx -= this.gtest;
            this.gy -= this.gtest;
            this.dcstep();
            this.fx += this.stx * this.gtest;
            this.fy += this.sty * this.gtest;
            this.gx += this.gtest;
            this.gy += this.gtest;
        } else {
            this.dcstep();
        }
        if (this.bracket) {
            if (Math.abs(this.sty - this.stx) >= 0.66 * this.width1) {
                this.stp = this.stx + 0.5 * (this.sty - this.stx);
            }
            this.width1 = this.width;
            this.width = Math.abs(this.sty - this.stx);
        }
        if (this.bracket) {
            this.stmin = Math.min(this.stx, this.sty);
            this.stmax = Math.max(this.stx, this.sty);
        } else {
            this.stmin = this.stp + 1.1 * (this.stp - this.stx);
            this.stmax = this.stp + 4.0 * (this.stp - this.stx);
        }
        this.stp = Math.max(this.stp, this.stpmin);
        this.stp = Math.min(this.stp, this.stpmax);
        if (this.bracket && (this.stp <= this.stmin || this.stp >= this.stmax) || this.bracket && this.stmax - this.stmin <= this.xtol * this.stmax) {
            this.stp = this.stx;
        }
        this.updated = true;
        return false;
    }

    private void dcstep() {
        double sgnd = this.gp * Math.signum(this.gx);
        double stpf = this.fp > this.fx ? this.handleCase1() : (sgnd < 0.0 ? this.handleCase2() : (Math.abs(this.gp) < Math.abs(this.gx) ? this.handleCase3() : this.handleCase4()));
        if (this.fp > this.fx) {
            this.sty = this.stp;
            this.fy = this.fp;
            this.gy = this.gp;
        } else {
            if (sgnd < 0.0) {
                this.sty = this.stx;
                this.fy = this.fx;
                this.gy = this.gx;
            }
            this.stx = this.stp;
            this.fx = this.fp;
            this.gx = this.gp;
        }
        this.stp = stpf;
        this.updated = true;
    }

    private double handleCase1() {
        double stpc = SearchInterpolate.cubic2(this.fx, this.gx, this.stx, this.fp, this.gp, this.stp);
        double stpq = SearchInterpolate.quadratic(this.fx, this.gx, this.stx, this.fp, this.stp);
        this.bracket = true;
        if (Math.abs(stpc - this.stx) < Math.abs(stpq - this.stx)) {
            return stpc;
        }
        return stpc + (stpq - stpc) / 2.0;
    }

    private double handleCase2() {
        double stpc = SearchInterpolate.cubic2(this.fp, this.gp, this.stp, this.fx, this.gx, this.stx);
        double stpq = SearchInterpolate.quadratic2(this.gp, this.stp, this.gx, this.stx);
        this.bracket = true;
        if (Math.abs(stpc - this.stp) > Math.abs(stpq - this.stp)) {
            return stpc;
        }
        return stpq;
    }

    private double handleCase3() {
        double stpf;
        double stpc = SearchInterpolate.cubicSafe(this.fp, this.gp, this.stp, this.fx, this.gx, this.stx, this.stmin, this.stmax);
        double stpq = SearchInterpolate.quadratic2(this.gp, this.stp, this.gx, this.stx);
        if (this.bracket) {
            stpf = Math.abs(stpc - this.stp) < Math.abs(stpq - this.stp) ? stpc : stpq;
            stpf = this.stp > this.stx ? Math.min(this.stp + 0.66 * (this.sty - this.stp), stpf) : Math.max(this.stp + 0.66 * (this.sty - this.stp), stpf);
        } else {
            stpf = Math.abs(stpc - this.stp) > Math.abs(stpq - this.stp) ? stpc : stpq;
            stpf = Math.min(this.stmax, stpf);
            stpf = Math.max(this.stmin, stpf);
        }
        return stpf;
    }

    private double handleCase4() {
        if (this.bracket) {
            return SearchInterpolate.cubic2(this.fp, this.gp, this.stp, this.fy, this.gy, this.sty);
        }
        if (this.stp > this.stx) {
            return this.stmax;
        }
        return this.stmin;
    }

    @Override
    public boolean isConverged() {
        return this.converged;
    }

    @Override
    public double getStep() {
        return this.stp;
    }

    @Override
    public String getWarning() {
        return this.message;
    }

    @Override
    public double getFunction() {
        return this.fp;
    }

    @Override
    public boolean isUpdated() {
        return this.updated;
    }
}

