/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.D1Matrix64F;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;

public abstract class LevenbergBase {
    protected int N;
    protected int M;
    private double gtol;
    private double ftol;
    private DenseMatrix64F x = new DenseMatrix64F(1, 1);
    private DenseMatrix64F g = new DenseMatrix64F(1, 1);
    private DenseMatrix64F funcVals = new DenseMatrix64F(1, 1);
    private DenseMatrix64F xtest = new DenseMatrix64F(1, 1);
    private DenseMatrix64F xdelta = new DenseMatrix64F(1, 1);
    private double fnorm;
    private double fnormPrev;
    private double dampParam;
    private double initialDampParam;
    private double nu;
    private int mode;
    private boolean updatedParameters;
    private boolean hasConverged;
    private int iterationCount;
    private String message;

    public LevenbergBase(double initialDampParam) {
        this.initialDampParam = initialDampParam;
    }

    public void setConvergence(double ftol, double gtol) {
        if (ftol < 0.0 || ftol >= 1.0) {
            throw new IllegalArgumentException("0 <= ftol < 1");
        }
        if (gtol < 0.0) {
            throw new IllegalArgumentException("gtol < 0 ");
        }
        this.gtol = gtol;
        this.ftol = ftol;
    }

    public void setInitialDampParam(double initialDampParam) {
        this.initialDampParam = initialDampParam;
    }

    protected void internalInitialize(int numParameters, int numFunctions) {
        this.N = numParameters;
        this.M = numFunctions;
        this.x.reshape(this.N, 1, false);
        this.g.reshape(this.N, 1, false);
        this.xdelta.reshape(this.N, 1, false);
        this.xtest.reshape(this.N, 1, false);
        this.funcVals.reshape(this.M, 1, false);
    }

    public void initialize(double[] initial) {
        if (initial.length < this.N) {
            throw new IllegalArgumentException("Expected N=" + this.N + " parameters");
        }
        System.arraycopy(initial, 0, this.x.data, 0, this.N);
        this.setFunctionParameters(this.x.data);
        this.computeResiduals(this.funcVals.data);
        this.fnorm = this.computeError();
        this.fnormPrev = 0.0;
        this.hasConverged = false;
        this.mode = 0;
        this.dampParam = this.initialDampParam;
        this.nu = 2.0;
        this.iterationCount = 0;
        this.message = "";
    }

    protected abstract void setFunctionParameters(double[] var1);

    protected abstract void computeResiduals(double[] var1);

    protected abstract void computeJacobian(DenseMatrix64F var1, DenseMatrix64F var2);

    protected abstract boolean computeStep(double var1, DenseMatrix64F var3, DenseMatrix64F var4);

    protected abstract double predictedReduction(DenseMatrix64F var1, DenseMatrix64F var2, double var3);

    protected abstract double getMinimumDampening();

    public double[] getParameters() {
        return this.x.data;
    }

    public boolean iterate() {
        this.updatedParameters = false;
        if (this.mode == 0) {
            return this.initSamplePoint();
        }
        return !this.computeStep();
    }

    private boolean initSamplePoint() {
        this.computeJacobian(this.funcVals, this.g);
        CommonOps.scale(-1.0, this.g);
        double gx = CommonOps.elementMaxAbs(this.g);
        if (Math.abs(this.fnorm - this.fnormPrev) <= this.ftol * Math.max(this.fnorm, this.fnormPrev) || Math.abs(gx) <= this.gtol) {
            return this.terminateSearch(true, null);
        }
        this.fnormPrev = this.fnorm;
        this.mode = 1;
        return false;
    }

    private boolean computeStep() {
        if (!this.solveForXDelta()) {
            return false;
        }
        CommonOps.add((D1Matrix64F)this.x, this.xdelta, (D1Matrix64F)this.xtest);
        CommonOps.subtract((D1Matrix64F)this.xtest, (D1Matrix64F)this.x, (D1Matrix64F)this.xdelta);
        this.setFunctionParameters(this.xtest.data);
        this.computeResiduals(this.funcVals.data);
        double ftestnorm = this.computeError();
        double actualReduction = this.fnorm - ftestnorm;
        double predictedReduction = this.predictedReduction(this.xdelta, this.g, this.dampParam);
        if (predictedReduction > 0.0 && actualReduction >= 0.0) {
            DenseMatrix64F temp = this.x;
            this.x = this.xtest;
            this.xtest = temp;
            this.fnorm = ftestnorm;
            double ratio = actualReduction / predictedReduction;
            this.dampParam *= Math.max(0.3333333, 1.0 - Math.pow(2.0 * ratio - 1.0, 3.0));
            this.nu = 2.0;
            this.mode = 0;
            ++this.iterationCount;
            this.updatedParameters = true;
        } else {
            this.dampParam *= this.nu;
            this.nu *= 2.0;
        }
        return !Double.isInfinite(this.dampParam) && !Double.isNaN(this.dampParam);
    }

    protected boolean solveForXDelta() {
        boolean failed = true;
        for (int iter = 0; iter < 1000 && failed; ++iter) {
            if (this.computeStep(this.dampParam, this.g, this.xdelta)) {
                failed = false;
            }
            if (!failed) continue;
            this.dampParam = Math.max(10.0 * this.dampParam, this.getMinimumDampening());
        }
        if (failed) {
            this.addToMessage("Failed to find dampParam which cold be solved");
            return false;
        }
        return true;
    }

    private boolean terminateSearch(boolean converged, String message) {
        this.hasConverged = converged;
        return true;
    }

    private double computeError() {
        return VectorVectorMult.innerProd(this.funcVals, this.funcVals) / 2.0;
    }

    public boolean isConverged() {
        return this.hasConverged;
    }

    public int getIterationCount() {
        return this.iterationCount;
    }

    public void addToMessage(String message) {
        this.message = this.message + message + "\n";
    }

    public String getMessage() {
        return this.message;
    }

    public double getFnorm() {
        return this.fnorm;
    }

    public boolean isUpdatedParameters() {
        return this.updatedParameters;
    }
}

