/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.simple.SimpleMatrix;

public class EquationsBFGS {
    public static void naiveInverseUpdate(DenseMatrix64F H, DenseMatrix64F s, DenseMatrix64F y) {
        SimpleMatrix _y = new SimpleMatrix(y);
        SimpleMatrix _s = new SimpleMatrix(s);
        SimpleMatrix B = new SimpleMatrix(H);
        SimpleMatrix I = SimpleMatrix.identity(_y.getNumElements());
        double p = 1.0 / _y.dot(_s);
        SimpleMatrix A1 = (SimpleMatrix)I.minus(((SimpleMatrix)_s.mult(_y.transpose())).scale(p));
        SimpleMatrix A2 = (SimpleMatrix)I.minus(((SimpleMatrix)_y.mult(_s.transpose())).scale(p));
        SimpleMatrix SS = (SimpleMatrix)((SimpleMatrix)_s.mult(_s.transpose())).scale(p);
        SimpleMatrix M = A1.mult(B).mult(A2).plus(SS);
        H.set(M.getMatrix());
    }

    public static void inverseUpdate(DenseMatrix64F H, DenseMatrix64F s, DenseMatrix64F y, DenseMatrix64F tempV0, DenseMatrix64F tempV1) {
        int N;
        double alpha = VectorVectorMult.innerProdA(y, H, y);
        double p = 1.0 / VectorVectorMult.innerProd(s, y);
        tempV0.numRows = N = H.numCols;
        tempV0.numCols = 1;
        tempV1.numRows = 1;
        tempV1.numCols = N;
        CommonOps.mult(H, y, tempV0);
        CommonOps.multTransA(y, H, tempV1);
        VectorVectorMult.rank1Update(-p, H, tempV0, s);
        VectorVectorMult.rank1Update(-p, H, s, tempV1);
        VectorVectorMult.rank1Update(p * alpha * p + p, H, s, s);
    }

    public static void conjugateUpdateD(DenseMatrix64F C, DenseMatrix64F d, DenseMatrix64F y, double step, DenseMatrix64F tempV0) {
        DenseMatrix64F z = tempV0;
        CommonOps.multTransA(C, y, z);
        double dTd = VectorVectorMult.innerProd(d, d);
        double dTz = VectorVectorMult.innerProd(d, z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }

    public static void conjugateUpdateC(DenseMatrix64F C, DenseMatrix64F d, DenseMatrix64F y, double step, DenseMatrix64F tempV0, DenseMatrix64F tempV1) {
        DenseMatrix64F z = tempV0;
        DenseMatrix64F d_bar = tempV1;
        CommonOps.multTransA(C, y, z);
        double dTd = VectorVectorMult.innerProd(d, d);
        double dTz = VectorVectorMult.innerProd(d, z);
        double middleScale = -dTd / dTz;
        double rightScale = dTd / Math.sqrt(-dTd * dTz / step);
        int N = d.getNumElements();
        for (int i = 0; i < N; ++i) {
            int n = i;
            d.data[n] = d.data[n] + (middleScale * z.data[i] + rightScale * d.data[i]);
        }
    }
}

