/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.impl;

import org.ddogleg.optimization.impl.TrustRegionStep;
import org.ejml.alg.dense.mult.VectorVectorMult;
import org.ejml.data.DenseMatrix64F;
import org.ejml.ops.CommonOps;
import org.ejml.ops.NormOps;

public class CauchyStep
implements TrustRegionStep {
    private DenseMatrix64F B = new DenseMatrix64F(1, 1);
    private DenseMatrix64F gradient;
    private double gBg;
    private double gnorm;
    private boolean maxStep;
    private double predicted;

    @Override
    public void init(int numParam, int numFunctions) {
        this.B.reshape(numParam, numParam);
    }

    @Override
    public void setInputs(DenseMatrix64F x, DenseMatrix64F residuals, DenseMatrix64F J, DenseMatrix64F gradient, double fx) {
        this.gradient = gradient;
        CommonOps.multInner(J, this.B);
        this.gBg = VectorVectorMult.innerProdA(gradient, this.B, gradient);
        this.gnorm = NormOps.normF(gradient);
    }

    @Override
    public void computeStep(double regionRadius, DenseMatrix64F step) {
        double dist;
        double normRadius = regionRadius / this.gnorm;
        if (this.gBg == 0.0) {
            dist = normRadius;
            this.maxStep = true;
        } else {
            dist = this.gnorm * this.gnorm / this.gBg;
            if (dist >= normRadius) {
                this.maxStep = true;
                dist = normRadius;
            } else {
                this.maxStep = false;
            }
        }
        CommonOps.scale(-dist, this.gradient, step);
        this.predicted = dist * this.gnorm * this.gnorm - 0.5 * dist * dist * this.gBg;
    }

    @Override
    public double predictedReduction() {
        return this.predicted;
    }

    @Override
    public boolean isMaxStep() {
        return this.maxStep;
    }
}

