/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;

public class EvalFuncTrigonometric
implements EvalFuncLeastSquares {
    int N;

    public EvalFuncTrigonometric(int n) {
        this.N = n;
    }

    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return null;
    }

    @Override
    public double[] getInitial() {
        double[] x = new double[this.N];
        for (int i = 0; i < this.N; ++i) {
            x[i] = 1.0 / (double)this.N;
        }
        return x;
    }

    @Override
    public double[] getOptimal() {
        return null;
    }

    public class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return EvalFuncTrigonometric.this.N;
        }

        @Override
        public int getNumOfOutputsM() {
            return EvalFuncTrigonometric.this.N;
        }

        @Override
        public void process(double[] input, double[] output) {
            for (int i = 0; i < input.length; ++i) {
                output[i] = this.F(input, i);
            }
        }

        public double F(double[] x, int degree) {
            double total = EvalFuncTrigonometric.this.N;
            for (int i = 0; i < EvalFuncTrigonometric.this.N; ++i) {
                total -= Math.cos(x[i]);
            }
            return total += (double)(degree + 1) * (1.0 - Math.cos(x[degree])) - Math.sin(x[degree]);
        }
    }
}

