/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DenseMatrix64F;

public class EvalFuncHelicalValley
implements EvalFuncLeastSquares {
    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return null;
    }

    @Override
    public double[] getInitial() {
        return new double[]{-1.0, 0.0, 0.0};
    }

    @Override
    public double[] getOptimal() {
        return new double[]{1.0, 0.0, 0.0};
    }

    public static class Deriv
    implements FunctionNtoMxN {
        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            DenseMatrix64F J = DenseMatrix64F.wrap(3, 3, output);
            double x1 = input[0];
            double x2 = input[1];
            double x3 = input[2];
        }
    }

    public static class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 3;
        }

        @Override
        public int getNumOfOutputsM() {
            return 3;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            double x3 = input[2];
            output[0] = 10.0 * (x3 - 10.0 * this.phi(x1, x2));
            output[1] = 10.0 * (Math.sqrt(x1 * x1 + x2 * x2) - 1.0);
            output[2] = x3;
        }

        private double phi(double a, double b) {
            double left = 0.15915494309189535;
            if (a > 0.0) {
                return left * Math.atan(b / a);
            }
            return left * Math.atan(b / a) + 0.5;
        }
    }
}

