/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncMinimization;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;

public class EvalFuncDodcfg
implements EvalFuncMinimization {
    int nx;
    int ny;
    double lambda;
    double hx;
    double hy;
    double hxhy;
    double area;
    double t1;
    double t2;
    double p25 = 0.25;
    double p5 = 0.5;
    double zero = 0.0;
    double one = 1.0;
    double two = 2.0;
    double mu1 = this.one;
    double mu2 = this.two;

    public EvalFuncDodcfg(int nx, int ny, double lambda) {
        this.nx = nx;
        this.ny = ny;
        this.lambda = lambda;
        this.hx = 1.0 / (double)(nx + 1);
        this.hy = 1.0 / (double)(ny + 1);
        this.hxhy = this.hx * this.hy;
        this.area = this.p5 * this.hxhy;
        this.t1 = Math.sqrt(this.two * lambda * this.mu1 / this.mu2);
        this.t2 = Math.sqrt(this.two * lambda * this.mu2 / this.mu1);
    }

    @Override
    public double getMinimum() {
        return -1.0E30;
    }

    @Override
    public FunctionNtoS getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoN getGradient() {
        return new Deriv();
    }

    @Override
    public double[] getInitial() {
        double[] x = new double[this.nx * this.ny];
        for (int j = 1; j <= this.ny; ++j) {
            double temp = (double)Math.min(j, this.ny - j + 1) * this.hy;
            for (int i = 1; i <= this.nx; ++i) {
                int k = this.nx * (j - 1) + i;
                double a = Math.min((double)Math.min(i, this.nx - i + 1) * this.hx, temp);
                x[this.fi((int)k)] = -a * a;
            }
        }
        return x;
    }

    @Override
    public double[] getOptimal() {
        return null;
    }

    public double computeStuff(boolean feval, boolean geval, double[] x, double[] fgrad) {
        double dpsip;
        double dpsi;
        double gradv;
        double dvdy;
        double dvdx;
        int k;
        int i;
        int j;
        double f = 0.0;
        if (geval) {
            for (int k2 = 1; k2 <= this.nx * this.ny; ++k2) {
                fgrad[k2 - 1] = this.zero;
            }
        }
        for (j = 0; j <= this.ny; ++j) {
            for (i = 0; i <= this.nx; ++i) {
                k = this.nx * (j - 1) + i;
                double v = this.zero;
                double vr = this.zero;
                double vt = this.zero;
                if (j >= 1 && i >= 1) {
                    v = x[this.fi(k)];
                }
                if (i < this.nx && j > 0) {
                    vr = x[this.fi(k + 1)];
                }
                if (i > 0 && j < this.ny) {
                    vt = x[this.fi(k + this.nx)];
                }
                dvdx = (vr - v) / this.hx;
                dvdy = (vt - v) / this.hy;
                gradv = dvdx * dvdx + dvdy * dvdy;
                if (feval) {
                    dpsi = this.dodcps(gradv, this.mu1, this.mu2, this.t1, this.t2, 0, this.lambda);
                    f += dpsi;
                }
                if (!geval) continue;
                dpsip = this.dodcps(gradv, this.mu1, this.mu2, this.t1, this.t2, 1, this.lambda);
                if (i >= 1 && j >= 1) {
                    int n = this.fi(k);
                    fgrad[n] = fgrad[n] - this.two * (dvdx / this.hx + dvdy / this.hy) * dpsip;
                }
                if (i < this.nx && j > 0) {
                    int n = this.fi(k + 1);
                    fgrad[n] = fgrad[n] + this.two * (dvdx / this.hx) * dpsip;
                }
                if (i <= 0 || j >= this.ny) continue;
                int n = this.fi(k + this.nx);
                fgrad[n] = fgrad[n] + this.two * (dvdy / this.hy) * dpsip;
            }
        }
        for (j = 1; j <= this.ny + 1; ++j) {
            for (i = 1; i <= this.nx + 1; ++i) {
                k = this.nx * (j - 1) + i;
                double vb = this.zero;
                double vl = this.zero;
                double v = this.zero;
                if (i <= this.nx && j > 1) {
                    vb = x[this.fi(k - this.nx)];
                }
                if (i > 1 && j <= this.ny) {
                    vl = x[this.fi(k - 1)];
                }
                if (i <= this.nx && j <= this.ny) {
                    v = x[this.fi(k)];
                }
                dvdx = (v - vl) / this.hx;
                dvdy = (v - vb) / this.hy;
                gradv = dvdx * dvdx + dvdy * dvdy;
                if (feval) {
                    dpsi = this.dodcps(gradv, this.mu1, this.mu2, this.t1, this.t2, 0, this.lambda);
                    f += dpsi;
                }
                if (!geval) continue;
                dpsip = this.dodcps(gradv, this.mu1, this.mu2, this.t1, this.t2, 1, this.lambda);
                if (i <= this.nx && j > 1) {
                    int n = this.fi(k - this.nx);
                    fgrad[n] = fgrad[n] - this.two * (dvdy / this.hy) * dpsip;
                }
                if (i > 1 && j <= this.ny) {
                    int n = this.fi(k - 1);
                    fgrad[n] = fgrad[n] - this.two * (dvdx / this.hx) * dpsip;
                }
                if (i > this.nx || j > this.ny) continue;
                int n = this.fi(k);
                fgrad[n] = fgrad[n] + this.two * (dvdx / this.hx + dvdy / this.hy) * dpsip;
            }
        }
        if (feval) {
            f = this.area * f;
        }
        if (feval) {
            double temp = this.zero;
            for (k = 1; k <= this.nx * this.ny; ++k) {
                temp += x[this.fi(k)];
            }
            f += this.hxhy * temp;
        }
        if (geval) {
            for (int k3 = 1; k3 <= this.nx * this.ny; ++k3) {
                fgrad[this.fi((int)k3)] = this.area * fgrad[this.fi(k3)] + this.hxhy;
            }
        }
        return f;
    }

    public double dodcps(double t, double mu1, double mu2, double t1, double t2, int option, double lambda) {
        double result = Double.NaN;
        double sqrtt = Math.sqrt(t);
        if (option == 0) {
            if (sqrtt <= t1) {
                result = this.p5 * mu2 * t;
            } else if (sqrtt > t1 && sqrtt < t2) {
                result = mu2 * t1 * sqrtt - lambda * mu1;
            } else if (sqrtt >= t2) {
                result = this.p5 * mu1 * t + lambda * (mu2 - mu1);
            }
        } else if (option == 1) {
            if (sqrtt <= t1) {
                result = this.p5 * mu2;
            } else if (sqrtt > t1 && sqrtt < t2) {
                result = this.p5 * mu2 * t1 / sqrtt;
            } else if (sqrtt >= t2) {
                result = this.p5 * mu1;
            }
        } else if (option == 2) {
            if (sqrtt <= t1) {
                result = this.zero;
            } else if (sqrtt > t1 && sqrtt < t2) {
                result = -this.p25 * mu2 * t1 / (sqrtt * t);
            } else if (sqrtt >= t2) {
                result = this.zero;
            }
        }
        if (Double.isNaN(result)) {
            throw new RuntimeException("Bad");
        }
        return result;
    }

    private int fi(int i) {
        return i - 1;
    }

    public class Deriv
    implements FunctionNtoN {
        @Override
        public int getN() {
            return EvalFuncDodcfg.this.nx * EvalFuncDodcfg.this.ny;
        }

        @Override
        public void process(double[] input, double[] output) {
            EvalFuncDodcfg.this.computeStuff(false, true, input, output);
        }
    }

    public class Func
    implements FunctionNtoS {
        @Override
        public int getNumOfInputsN() {
            return EvalFuncDodcfg.this.nx * EvalFuncDodcfg.this.ny;
        }

        @Override
        public double process(double[] input) {
            return EvalFuncDodcfg.this.computeStuff(true, false, input, null);
        }
    }
}

