/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization.funcs;

import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.functions.FunctionNtoM;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ejml.data.DenseMatrix64F;

public class EvalFuncCurveFit
implements EvalFuncLeastSquares {
    double[] t;
    double[] f;

    public EvalFuncCurveFit(double x1, double x2, double x3, double x4, double deltaT, int N) {
        this.t = new double[N];
        this.f = new double[N];
        for (int i = 0; i < N; ++i) {
            this.t[i] = deltaT * (double)i;
            this.f[i] = EvalFuncCurveFit.model(x1, x2, x3, x4, this.t[i]);
        }
    }

    @Override
    public FunctionNtoM getFunction() {
        return new Func();
    }

    @Override
    public FunctionNtoMxN getJacobian() {
        return new Deriv();
    }

    @Override
    public double[] getInitial() {
        return new double[]{-1.2, 1.0};
    }

    @Override
    public double[] getOptimal() {
        return new double[]{1.0, 1.0};
    }

    public static double model(double x1, double x2, double x3, double x4, double t) {
        return x3 * Math.exp(x1 * t) + x4 * Math.exp(x2 * t);
    }

    public class Deriv
    implements FunctionNtoMxN {
        @Override
        public int getNumOfInputsN() {
            return 2;
        }

        @Override
        public int getNumOfOutputsM() {
            return EvalFuncCurveFit.this.t.length;
        }

        @Override
        public void process(double[] input, double[] output) {
            DenseMatrix64F J = DenseMatrix64F.wrap(EvalFuncCurveFit.this.t.length, 2, output);
            double x1 = input[0];
            double x2 = input[1];
            double x3 = input[2];
            double x4 = input[3];
            for (int i = 0; i < EvalFuncCurveFit.this.t.length; ++i) {
                double g1 = -x3 * EvalFuncCurveFit.this.t[i] * Math.exp(x1 * EvalFuncCurveFit.this.t[i]);
                double g2 = -x4 * EvalFuncCurveFit.this.t[i] * Math.exp(x2 * EvalFuncCurveFit.this.t[i]);
                double g3 = -Math.exp(x1 * EvalFuncCurveFit.this.t[i]);
                double g4 = -Math.exp(x2 * EvalFuncCurveFit.this.t[i]);
                J.set(i, 0, g1);
                J.set(i, 1, g2);
                J.set(i, 2, g3);
                J.set(i, 3, g4);
            }
            J.set(0, 0, 1.0);
            J.set(0, 1, 0.0);
            J.set(1, 0, 1.0 / Math.pow(x1 + 0.1, 2.0));
            J.set(1, 1, 4.0 * x2);
        }
    }

    public class Func
    implements FunctionNtoM {
        @Override
        public int getNumOfInputsN() {
            return 4;
        }

        @Override
        public int getNumOfOutputsM() {
            return EvalFuncCurveFit.this.t.length;
        }

        @Override
        public void process(double[] input, double[] output) {
            double x1 = input[0];
            double x2 = input[1];
            double x3 = input[2];
            double x4 = input[3];
            for (int i = 0; i < EvalFuncCurveFit.this.t.length; ++i) {
                output[i] = EvalFuncCurveFit.this.f[i] - EvalFuncCurveFit.model(x1, x2, x3, x4, EvalFuncCurveFit.this.t[i]);
            }
        }
    }
}

