/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.optimization;

import org.ddogleg.optimization.CallCounterNtoN;
import org.ddogleg.optimization.CallCounterNtoS;
import org.ddogleg.optimization.NonlinearResults;
import org.ddogleg.optimization.UnconstrainedMinimization;
import org.ddogleg.optimization.funcs.EvalFuncBadlyScaledBrown;
import org.ddogleg.optimization.funcs.EvalFuncDodcfg;
import org.ddogleg.optimization.funcs.EvalFuncHelicalValley;
import org.ddogleg.optimization.funcs.EvalFuncLeastSquares;
import org.ddogleg.optimization.funcs.EvalFuncMinimization;
import org.ddogleg.optimization.funcs.EvalFuncPowell;
import org.ddogleg.optimization.funcs.EvalFuncRosenbrock;
import org.ddogleg.optimization.funcs.EvalFuncRosenbrockMod;
import org.ddogleg.optimization.funcs.EvalFuncTrigonometric;
import org.ddogleg.optimization.funcs.EvalFuncVariablyDimensioned;
import org.ddogleg.optimization.functions.FunctionNtoMxN;
import org.ddogleg.optimization.functions.FunctionNtoN;
import org.ddogleg.optimization.functions.FunctionNtoS;
import org.ddogleg.optimization.impl.NumericalGradientForward;
import org.ddogleg.optimization.wrap.LsToNonLinear;
import org.ddogleg.optimization.wrap.LsToNonLinearDeriv;

public abstract class UnconstrainedMinimizationEvaluator {
    boolean verbose = true;
    boolean printSummary = true;
    int maxIteration = 1000;

    protected UnconstrainedMinimizationEvaluator(boolean verbose, boolean printSummary) {
        this.verbose = verbose;
        this.printSummary = printSummary;
    }

    protected abstract UnconstrainedMinimization createSearch();

    private NonlinearResults performTest(FunctionNtoS func, FunctionNtoN deriv, double[] initial, double[] optimal, double minimValue) {
        int iter;
        if (deriv == null) {
            deriv = new NumericalGradientForward(func);
        }
        CallCounterNtoS f = new CallCounterNtoS(func);
        CallCounterNtoN d = new CallCounterNtoN(deriv);
        UnconstrainedMinimization alg = this.createSearch();
        alg.setFunction(f, d, minimValue);
        double initialValue = func.process(initial);
        alg.initialize(initial, 1.0E-12, 1.0E-12);
        for (iter = 0; iter < this.maxIteration && !alg.iterate(); ++iter) {
            this.printError(optimal, alg);
        }
        this.printError(optimal, alg);
        if (this.verbose) {
            System.out.println("*** total iterations = " + iter);
        }
        double[] found = alg.getParameters();
        double finalValue = func.process(found);
        if (this.printSummary) {
            System.out.printf("value{ init %4.1e final = %6.2e} count f = %2d d = %2d\n", initialValue, finalValue, f.count, d.count);
        }
        NonlinearResults ret = new NonlinearResults();
        ret.numFunction = f.count;
        ret.numGradient = d.count;
        ret.f = finalValue;
        ret.x = found;
        return ret;
    }

    private void printError(double[] optimal, UnconstrainedMinimization alg) {
        if (optimal != null) {
            double[] x = alg.getParameters();
            double n = 0.0;
            for (int j = 0; j < x.length; ++j) {
                double dx = x[j] - optimal[j];
                n += dx * dx;
            }
            if (this.verbose) {
                System.out.println("||x(k)-x(*)|| = " + Math.sqrt(n));
            }
        }
    }

    private NonlinearResults performTest(EvalFuncLeastSquares func) {
        LsToNonLinearDeriv gradient;
        LsToNonLinear nl = new LsToNonLinear(func.getFunction());
        double[] initial = func.getInitial();
        FunctionNtoMxN jacobian = func.getJacobian();
        LsToNonLinearDeriv lsToNonLinearDeriv = gradient = jacobian == null ? null : new LsToNonLinearDeriv(func.getFunction(), jacobian);
        if (this.verbose && func.getOptimal() != null) {
            System.out.println("optimal = " + nl.process(func.getOptimal()));
        }
        return this.performTest(nl, gradient, initial, func.getOptimal(), 0.0);
    }

    private NonlinearResults performTest(EvalFuncMinimization func) {
        double[] initial = func.getInitial();
        FunctionNtoS nl = func.getFunction();
        if (this.verbose && func.getOptimal() != null) {
            System.out.println("optimal = " + nl.process(func.getOptimal()));
        }
        return this.performTest(nl, func.getGradient(), initial, func.getOptimal(), func.getMinimum());
    }

    public NonlinearResults helicalValley() {
        return this.performTest(new EvalFuncHelicalValley());
    }

    public NonlinearResults rosenbrock() {
        return this.performTest(new EvalFuncRosenbrock());
    }

    public NonlinearResults rosenbrockMod(double lambda) {
        return this.performTest(new EvalFuncRosenbrockMod(lambda));
    }

    public NonlinearResults dodcfg() {
        return this.performTest(new EvalFuncDodcfg(50, 50, 0.008));
    }

    public NonlinearResults variably() {
        return this.performTest(new EvalFuncVariablyDimensioned(10));
    }

    public NonlinearResults trigonometric() {
        return this.performTest(new EvalFuncTrigonometric(10));
    }

    public NonlinearResults badlyScaledBrown() {
        return this.performTest(new EvalFuncBadlyScaledBrown());
    }

    public NonlinearResults powell() {
        return this.performTest(new EvalFuncPowell());
    }
}

