/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeSearch1Bbf;
import org.ddogleg.nn.alg.KdTreeSearchN;
import org.ddogleg.nn.alg.KdTreeSearchNBbf;
import org.ddogleg.nn.alg.StandardKdTreeSearch1Tests;
import org.ddogleg.nn.alg.StandardKdTreeSearchNTests;
import org.junit.Assert;
import org.junit.Test;

public class TestKdTreeSearchNBbf
extends StandardKdTreeSearchNTests {
    @Override
    public KdTreeSearchN createAlg() {
        return new KdTreeSearchNBbf(10000);
    }

    @Test
    public void checkMaxNodes() {
        KdTree tree = StandardKdTreeSearch1Tests.createTreeA();
        KdTreeSearch1Bbf alg = new KdTreeSearch1Bbf(0);
        alg.setTree(tree);
        KdTree.Node found = alg.findNeighbor(new double[]{12.0, 2.0});
        Assert.assertTrue((found == tree.root.left.right ? 1 : 0) != 0);
    }

    @Test
    public void multiTreeSearch() {
        KdTree[] forest = new KdTree[]{StandardKdTreeSearch1Tests.createTreeA(), new KdTree(2)};
        forest[1].root = new KdTree.Node(new double[]{12.0, 2.0}, null);
        KdTreeSearch1Bbf alg = new KdTreeSearch1Bbf(200);
        alg.setTrees(forest);
        KdTree.Node found = alg.findNeighbor(new double[]{12.0, 3.0});
        Assert.assertTrue((alg.numNodesSearched > 0 ? 1 : 0) != 0);
        Assert.assertTrue((found == forest[1].root ? 1 : 0) != 0);
    }
}

