/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.nn.alg;

import org.ddogleg.nn.alg.KdTree;
import org.ddogleg.nn.alg.KdTreeMemory;
import org.junit.Assert;
import org.junit.Test;

public class TestKdTreeMemory {
    @Test
    public void requestNode() {
        KdTreeMemory alg = new KdTreeMemory();
        KdTree.Node n = alg.requestNode();
        Assert.assertTrue((n.point == null ? 1 : 0) != 0);
        Assert.assertTrue((n.left == null ? 1 : 0) != 0);
        Assert.assertTrue((n.right == null ? 1 : 0) != 0);
        alg.unusedNodes.add(n);
        KdTree.Node m = alg.requestNode();
        Assert.assertTrue((n == m ? 1 : 0) != 0);
    }

    @Test
    public void requestNode_leaf() {
        KdTree.Node n = new KdTree.Node();
        n.point = new double[2];
        n.split = 123;
        n.data = 3;
        KdTreeMemory alg = new KdTreeMemory();
        alg.unusedNodes.add(n);
        KdTree.Node m = alg.requestNode(new double[]{1.0, 2.0}, 4);
        Assert.assertTrue((m == n ? 1 : 0) != 0);
        Assert.assertTrue((m.point[0] == 1.0 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)m.data.equals(4));
        Assert.assertTrue((m.split == -1 ? 1 : 0) != 0);
    }

    @Test
    public void requestTree() {
        KdTreeMemory alg = new KdTreeMemory();
        KdTree n = alg.requestTree();
        Assert.assertTrue((n.root == null ? 1 : 0) != 0);
        alg.unusedTrees.add(n);
        KdTree m = alg.requestTree();
        Assert.assertTrue((n == m ? 1 : 0) != 0);
    }

    @Test
    public void recycle() {
        KdTreeMemory alg = new KdTreeMemory();
        KdTree.Node n = new KdTree.Node();
        n.point = new double[2];
        n.left = n;
        n.right = n;
        alg.recycle(n);
        Assert.assertTrue((n.point == null ? 1 : 0) != 0);
        Assert.assertTrue((n.left == null ? 1 : 0) != 0);
        Assert.assertTrue((n.right == null ? 1 : 0) != 0);
        Assert.assertEquals((long)1L, (long)alg.unusedNodes.size());
    }

    @Test
    public void recycleGraph() {
        KdTreeMemory alg = new KdTreeMemory();
        KdTree tree = new KdTree();
        tree.root = new KdTree.Node();
        tree.root.left = new KdTree.Node();
        tree.root.right = new KdTree.Node();
        tree.root.left.left = new KdTree.Node();
        tree.root.left.right = new KdTree.Node();
        alg.recycleGraph(tree);
        Assert.assertEquals((long)0L, (long)alg.open.size());
        Assert.assertEquals((long)1L, (long)alg.unusedTrees.size());
        Assert.assertEquals((long)5L, (long)alg.unusedNodes.size());
    }

    @Test
    public void recycleGraph_nullRoot() {
        KdTreeMemory alg = new KdTreeMemory();
        KdTree tree = new KdTree();
        tree.root = null;
        alg.recycleGraph(tree);
        Assert.assertEquals((long)0L, (long)alg.open.size());
        Assert.assertEquals((long)1L, (long)alg.unusedTrees.size());
        Assert.assertEquals((long)0L, (long)alg.unusedNodes.size());
    }
}

