/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.GenericModelMatcherMultiTests;
import org.ddogleg.fitting.modelset.ModelMatcherMulti;
import org.ddogleg.fitting.modelset.ransac.RansacMulti;
import org.ddogleg.fitting.modelset.ransac.TestRansac;
import org.junit.Assert;
import org.junit.Test;

public class TestRansacMulti
extends GenericModelMatcherMultiTests {
    public TestRansacMulti() {
        this.configure(0.9, 0.05, true);
    }

    @Override
    public ModelMatcherMulti<Double> createModelMatcher(List<GenericModelMatcherMultiTests.ModelInfo> models) {
        ArrayList<RansacMulti.ObjectType> rm = new ArrayList<RansacMulti.ObjectType>();
        for (int i = 0; i < models.size(); ++i) {
            RansacMulti.ObjectType rm0 = new RansacMulti.ObjectType();
            GenericModelMatcherMultiTests.ModelInfo mo = models.get(i);
            rm0.modelManager = mo.manager;
            rm0.modelGenerator = mo.generator;
            rm0.modelDistance = mo.distance;
            rm0.thresholdFit = mo.fitThreshold;
            rm0.sampleSize = mo.minPoints;
            rm.add(rm0);
        }
        return new RansacMulti<Double>(344L, 2000, rm, Double.class);
    }

    @Test
    public void selectMatchSet() {
        double modelVal = 50.0;
        ArrayList dataSet = new ArrayList();
        for (int i = 0; i < 200; ++i) {
            dataSet.add(i);
        }
        ArrayList<RansacMulti.ObjectType> objectTypes = new ArrayList<RansacMulti.ObjectType>();
        RansacMulti.ObjectType obj0 = new RansacMulti.ObjectType();
        obj0.modelManager = new TestRansac.DebugModelStuff((int)modelVal);
        obj0.modelDistance = new TestRansac.DebugModelStuff((int)modelVal);
        obj0.modelGenerator = new TestRansac.DebugModelStuff((int)modelVal);
        obj0.thresholdFit = 1.0;
        objectTypes.add(obj0);
        RansacMulti<Integer> ransac = new RansacMulti<Integer>(234L, 20, objectTypes, Integer.class);
        ransac.setSampleSize(5);
        ransac.matchToInput = new int[dataSet.size()];
        double[] param = new double[]{modelVal};
        ransac.dataSet = dataSet;
        ransac.selectMatchSet(obj0.modelDistance, 4.0, param);
        Assert.assertTrue((ransac.candidatePoints.size() == 7 ? 1 : 0) != 0);
    }
}

