/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.fitting.modelset.ransac;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.fitting.modelset.DistanceFromModel;
import org.ddogleg.fitting.modelset.GenericModelMatcherTests;
import org.ddogleg.fitting.modelset.ModelFitter;
import org.ddogleg.fitting.modelset.ModelGenerator;
import org.ddogleg.fitting.modelset.ModelManager;
import org.ddogleg.fitting.modelset.ModelMatcher;
import org.ddogleg.fitting.modelset.ransac.Ransac;
import org.junit.Assert;
import org.junit.Test;

public class TestRansac
extends GenericModelMatcherTests {
    public TestRansac() {
        this.configure(0.9, 0.05, true);
    }

    @Override
    public ModelMatcher<double[], Double> createModelMatcher(ModelManager<double[]> manager, DistanceFromModel<double[], Double> distance, ModelGenerator<double[], Double> generator, ModelFitter<double[], Double> fitter, int minPoints, double fitThreshold) {
        Ransac<double[], Double> ret = new Ransac<double[], Double>(344L, manager, generator, distance, 200, fitThreshold);
        ret.setSampleSize(minPoints);
        return ret;
    }

    @Test
    public void randomDraw_large() {
        ArrayList<Integer> dataSet = new ArrayList<Integer>();
        for (int i = 0; i < 200; ++i) {
            dataSet.add(i);
        }
        ArrayList initSet = new ArrayList();
        Ransac.randomDraw(dataSet, 150, initSet, this.rand);
        Assert.assertEquals((long)150L, (long)initSet.size());
        int numTheSame = 0;
        for (int i = 0; i < initSet.size(); ++i) {
            Integer o = (Integer)initSet.get(i);
            Assert.assertTrue((boolean)dataSet.contains(o));
            if (o == i) {
                ++numTheSame;
            }
            for (int j = i + 1; j < initSet.size(); ++j) {
                if (o != initSet.get(j)) continue;
                Assert.fail((String)"Multiple copies in initSet");
            }
        }
        Assert.assertTrue(((double)numTheSame < (double)initSet.size() * 0.9 ? 1 : 0) != 0);
        Ransac.randomDraw(dataSet, 150, initSet, this.rand);
        Assert.assertEquals((long)150L, (long)initSet.size());
    }

    @Test
    public void randomDraw_small() {
        ArrayList<Integer> dataSet = new ArrayList<Integer>();
        for (int i = 0; i < 200; ++i) {
            dataSet.add(i);
        }
        ArrayList initSet = new ArrayList();
        Ransac.randomDraw(dataSet, 15, initSet, this.rand);
        Assert.assertEquals((long)15L, (long)initSet.size());
        for (int i = 0; i < initSet.size(); ++i) {
            Integer o = (Integer)initSet.get(i);
            Assert.assertTrue((boolean)dataSet.contains(o));
            Assert.assertTrue((dataSet.get(i) != o ? 1 : 0) != 0);
            for (int j = i + 1; j < initSet.size(); ++j) {
                if (o != initSet.get(j)) continue;
                Assert.fail((String)"Multiple copies in initSet");
            }
        }
        Ransac.randomDraw(dataSet, 15, initSet, this.rand);
        Assert.assertEquals((long)15L, (long)initSet.size());
    }

    @Test
    public void selectMatchSet() {
        double modelVal = 50.0;
        ArrayList<Integer> dataSet = new ArrayList<Integer>();
        for (int i = 0; i < 200; ++i) {
            dataSet.add(i);
        }
        DebugModelStuff stuff = new DebugModelStuff((int)modelVal);
        Ransac<double[], Integer> ransac = new Ransac<double[], Integer>(234L, stuff, stuff, stuff, 20, 1.0);
        ransac.setSampleSize(5);
        ransac.matchToInput = new int[dataSet.size()];
        double[] param = new double[]{modelVal};
        ransac.selectMatchSet(dataSet, 4.0, param);
        Assert.assertTrue((ransac.candidatePoints.size() == 7 ? 1 : 0) != 0);
    }

    public static class DebugModelStuff
    implements ModelManager<double[]>,
    DistanceFromModel<double[], Integer>,
    ModelGenerator<double[], Integer> {
        int threshold;
        double error;
        double[] param;

        public DebugModelStuff(int threshold) {
            this.threshold = threshold;
        }

        @Override
        public void setModel(double[] param) {
            this.param = param;
        }

        @Override
        public double computeDistance(Integer pt) {
            return Math.abs((double)pt.intValue() - this.param[0]);
        }

        @Override
        public void computeDistance(List<Integer> points, double[] distance) {
            throw new RuntimeException("Why was this called?");
        }

        @Override
        public double[] createModelInstance() {
            return new double[1];
        }

        @Override
        public void copyModel(double[] src, double[] dst) {
            System.arraycopy(src, 0, dst, 0, 1);
        }

        @Override
        public boolean generate(List<Integer> dataSet, double[] p) {
            this.error = 0.0;
            int offset = (int)p[0];
            for (Integer a : dataSet) {
                if (a + offset < this.threshold) continue;
                this.error += 1.0;
            }
            this.error += (double)offset;
            p[0] = this.error;
            return true;
        }

        @Override
        public int getMinimumPoints() {
            return 1;
        }
    }
}

