/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.util.List;
import org.ddogleg.example.Point2D;
import org.ddogleg.optimization.functions.FunctionNtoM;

public class FunctionLineDistanceEuclidean
implements FunctionNtoM {
    List<Point2D> data;

    public FunctionLineDistanceEuclidean(List<Point2D> data) {
        this.data = data;
    }

    @Override
    public int getNumOfInputsN() {
        return 2;
    }

    @Override
    public int getNumOfOutputsM() {
        return this.data.size() * 2;
    }

    @Override
    public void process(double[] input, double[] output) {
        double tanX = input[0];
        double tanY = input[1];
        double lineX = tanX;
        double lineY = tanY;
        double slopeX = -tanY;
        double slopeY = tanX;
        for (int i = 0; i < this.data.size(); ++i) {
            Point2D p = this.data.get(i);
            double t = slopeX * (p.x - lineX) + slopeY * (p.y - lineY);
            double closestX = lineX + (t /= slopeX * slopeX + slopeY * slopeY) * slopeX;
            double closestY = lineY + t * slopeY;
            output[i * 2] = p.x - closestX;
            output[i * 2 + 1] = p.y - closestY;
        }
    }
}

