/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.example;

import java.util.ArrayList;
import java.util.Random;
import org.ddogleg.example.FunctionLineDistanceEuclidean;
import org.ddogleg.example.Point2D;
import org.ddogleg.optimization.FactoryOptimization;
import org.ddogleg.optimization.UnconstrainedLeastSquares;
import org.ddogleg.optimization.UtilOptimize;

public class ExampleMinimization {
    public static void main(String[] args) {
        double lineX = -2.1;
        double lineY = 1.3;
        Random rand = new Random(234L);
        ArrayList<Point2D> points = new ArrayList<Point2D>();
        for (int i = 0; i < 20; ++i) {
            double t = (rand.nextDouble() - 0.5) * 10.0;
            points.add(new Point2D(lineX + t * lineY, lineY - t * lineX));
        }
        FunctionLineDistanceEuclidean func = new FunctionLineDistanceEuclidean(points);
        UnconstrainedLeastSquares optimizer = FactoryOptimization.leastSquaresLM(0.001, true);
        optimizer.setFunction(func, null);
        optimizer.initialize(new double[]{-0.5, 0.5}, 1.0E-12, 1.0E-12);
        UtilOptimize.process(optimizer, 500);
        double[] found = optimizer.getParameters();
        System.out.println("Final Error = " + optimizer.getFunctionValue());
        System.out.printf("Actual %5.2f  found %5.2f\n", lineX, found[0]);
        System.out.printf("Actual %5.2f  found %5.2f\n", lineY, found[1]);
    }
}

