/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.combinatorics;

import java.util.ArrayList;
import java.util.List;
import org.ddogleg.combinatorics.Permute;
import org.junit.Assert;
import org.junit.Test;

public class TestPermute {
    @Test
    public void testSetSize1() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        Permute alg = new Permute(l);
        Assert.assertEquals((long)1L, (long)alg.getTotalPermutations());
        Assert.assertFalse((boolean)alg.next());
    }

    @Test
    public void testSetSize2() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        Permute alg = new Permute(l);
        Assert.assertEquals((long)2L, (long)alg.getTotalPermutations());
        this.checkList(alg, 2);
    }

    @Test
    public void testSetSize3() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        Permute alg = new Permute(l);
        Assert.assertEquals((long)6L, (long)alg.getTotalPermutations());
        this.checkList(alg, 6);
    }

    @Test
    public void testSetSize4() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        l.add(4);
        Permute alg = new Permute(l);
        Assert.assertEquals((long)24L, (long)alg.getTotalPermutations());
        this.checkList(alg, 24);
    }

    @Test
    public void testSetSize5_to_7() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        l.add(1);
        l.add(2);
        l.add(3);
        l.add(4);
        l.add(5);
        int total = 120;
        for (int i = 0; i <= 2; ++i) {
            Permute alg = new Permute(l);
            Assert.assertEquals((long)total, (long)alg.getTotalPermutations());
            this.checkList(alg, total);
            l.add(6 + i);
            total *= l.size();
        }
    }

    @Test
    public void previous() {
        ArrayList<Integer> l = new ArrayList<Integer>();
        for (int size = 0; size < 9; ++size) {
            l.add(size);
            Permute alg = new Permute(l);
            ArrayList forward = new ArrayList();
            do {
                forward.add(alg.getPermutation(null));
            } while (alg.next());
            int i = forward.size() - 1;
            do {
                List found = alg.getPermutation(null);
                List expected = (List)forward.get(i--);
                for (int j = 0; j < size; ++j) {
                    Assert.assertTrue((found.get(j) == expected.get(j) ? 1 : 0) != 0);
                }
            } while (alg.previous());
        }
    }

    private void checkList(Permute p, int expected) {
        ArrayList all = new ArrayList();
        do {
            List l = p.getPermutation(null);
            for (int i = 0; i < l.size(); ++i) {
                Object o = l.get(i);
                for (int j = i + 1; j < l.size(); ++j) {
                    if (o != l.get(j)) continue;
                    Assert.fail((String)"duplicate");
                }
            }
            all.add(l);
        } while (p.next());
        Assert.assertEquals((long)expected, (long)all.size());
        for (int i = 0; i < expected; ++i) {
            List a = (List)all.get(i);
            Assert.assertEquals((long)a.size(), (long)p.size());
            for (int j = i + 1; j < expected; ++j) {
                List b = (List)all.get(j);
                boolean match = true;
                for (int k = 0; k < a.size(); ++k) {
                    if (a.get(k) == b.get(k)) continue;
                    match = false;
                    break;
                }
                Assert.assertFalse((boolean)match);
            }
        }
    }
}

