/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import junit.framework.TestCase;
import org.ddogleg.clustering.ComputeClusters;
import org.ddogleg.clustering.GenericClusterChecks_F64;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializeStandard_F64;
import org.ddogleg.clustering.kmeans.StandardKMeans_F64;
import org.junit.Test;

public class TestStandardKMeans_F64
extends GenericClusterChecks_F64 {
    @Test
    public void matchPointsToClusters() {
        StandardKMeans_F64 alg = new StandardKMeans_F64(100, 100, 1.0, new InitializeStandard_F64());
        alg.init(4, 123L);
        alg.clusters.resize(3);
        alg.workClusters.resize(3);
        alg.memberCount.resize(3);
        ((double[][])alg.clusters.data)[0] = new double[]{20.0, 0.0, 0.0, 0.0};
        ((double[][])alg.clusters.data)[1] = new double[]{0.0, 20.0, 0.0, 0.0};
        ((double[][])alg.clusters.data)[2] = new double[]{0.0, 0.0, 20.0, 0.0};
        ArrayList<double[]> points = new ArrayList<double[]>();
        points.add(new double[]{20.0, 5.0, 0.0, 0.0});
        points.add(new double[]{25.0, -4.0, 0.0, 0.0});
        points.add(new double[]{0.0, 0.0, 22.0, 0.0});
        alg.matchPointsToClusters(points);
        TestCase.assertEquals((int)2, (int)alg.memberCount.get(0));
        TestCase.assertEquals((int)0, (int)alg.memberCount.get(1));
        TestCase.assertEquals((int)1, (int)alg.memberCount.get(2));
        TestCase.assertEquals((double)45.0, (double)((double[][])alg.workClusters.data)[0][0], (double)1.0E-8);
        TestCase.assertEquals((double)1.0, (double)((double[][])alg.workClusters.data)[0][1], (double)1.0E-8);
        TestCase.assertEquals((double)0.0, (double)((double[][])alg.workClusters.data)[0][2], (double)1.0E-8);
        TestCase.assertEquals((double)0.0, (double)((double[][])alg.workClusters.data)[0][3], (double)1.0E-8);
        TestCase.assertEquals((double)0.0, (double)((double[][])alg.workClusters.data)[1][1], (double)1.0E-8);
        TestCase.assertEquals((double)22.0, (double)((double[][])alg.workClusters.data)[2][2], (double)1.0E-8);
    }

    @Test
    public void updateClusterCenters() {
        StandardKMeans_F64 alg = new StandardKMeans_F64(100, 100, 1.0, new InitializeStandard_F64());
        alg.init(4, 123L);
        alg.clusters.resize(3);
        alg.workClusters.resize(3);
        alg.memberCount.resize(3);
        double[][] orig = new double[3][4];
        orig[0] = new double[]{10.0, 20.0, 30.0, 20.0};
        orig[1] = new double[]{20.0, 10.0, 30.0, 40.0};
        orig[2] = new double[]{3.0, 9.0, 1.0, 12.0};
        ((double[][])alg.workClusters.data)[0] = (double[])orig[0].clone();
        ((double[][])alg.workClusters.data)[1] = (double[])orig[1].clone();
        ((double[][])alg.workClusters.data)[2] = (double[])orig[2].clone();
        alg.memberCount.data[0] = 10;
        alg.memberCount.data[1] = 1;
        alg.memberCount.data[2] = 3;
        alg.updateClusterCenters();
        for (int i = 0; i < 4; ++i) {
            TestCase.assertEquals((Object)((double[][])alg.clusters.data)[0][i], (Object)(orig[0][i] / 10.0));
            TestCase.assertEquals((Object)((double[][])alg.clusters.data)[1][i], (Object)(orig[1][i] / 1.0));
            TestCase.assertEquals((Object)((double[][])alg.clusters.data)[2][i], (Object)(orig[2][i] / 3.0));
        }
    }

    @Test
    public void distanceSq() {
        double[] a = new double[]{1.0, 2.0, 3.0, 4.0, 5.0};
        double[] b = new double[]{4.0, 6.0, 3.0, 1.0, -1.0};
        double found = StandardKMeans_F64.distanceSq(a, b);
        TestCase.assertEquals((double)70.0, (double)found, (double)1.0E-8);
    }

    public static List<double[]> createPoints(int DOF, int total, boolean fillRandom) {
        ArrayList<double[]> ret = new ArrayList<double[]>();
        Random random = new Random(23432 + DOF + total);
        for (int i = 0; i < total; ++i) {
            double[] a = new double[DOF];
            if (fillRandom) {
                for (int j = 0; j < a.length; ++j) {
                    a[j] = random.nextGaussian();
                }
            }
            ret.add(a);
        }
        return ret;
    }

    @Override
    public ComputeClusters<double[]> createClustersAlg(boolean hint) {
        if (hint) {
            return new StandardKMeans_F64(1000, 1000, 1.0E-8, new FixedSeeds());
        }
        InitializeStandard_F64 seeds = new InitializeStandard_F64();
        return new StandardKMeans_F64(1000, 1000, 1.0E-8, seeds);
    }

    public static class FixedSeeds
    implements InitializeKMeans_F64 {
        @Override
        public void init(int pointDimension, long randomSeed) {
        }

        @Override
        public void selectSeeds(List<double[]> points, List<double[]> seeds) {
            int N = seeds.get(0).length;
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(points.get(i), 0, seeds.get(i), 0, N);
            }
        }
    }
}

