/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.ArrayList;
import java.util.Random;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.clustering.kmeans.InitializePlusPlus;
import org.ddogleg.clustering.kmeans.StandardInitializeKMeansChecks;
import org.junit.Assert;
import org.junit.Test;

public class TestInitializePlusPlus
extends StandardInitializeKMeansChecks {
    Random rand = new Random(234L);

    @Test
    public void selectNextSeed() {
        InitializePlusPlus alg = new InitializePlusPlus();
        alg.init(1, 123L);
        alg.distance.resize(3);
        alg.distance.data = new double[]{3.0, 6.0, 1.0};
        alg.totalDistance = 10.0;
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (int i = 0; i < 3; ++i) {
            points.add(new double[1]);
        }
        double[] histogram = new double[3];
        for (int i = 0; i < 1000; ++i) {
            double[] seed = alg.selectNextSeed(points, this.rand.nextDouble());
            int which = -1;
            for (int j = 0; j < points.size(); ++j) {
                if (points.get(j) != seed) continue;
                which = j;
                break;
            }
            int n = which;
            histogram[n] = histogram[n] + 1.0;
        }
        Assert.assertEquals((double)0.3, (double)(histogram[0] / 1000.0), (double)0.02);
        Assert.assertEquals((double)0.6, (double)(histogram[1] / 1000.0), (double)0.02);
        Assert.assertEquals((double)0.1, (double)(histogram[2] / 1000.0), (double)0.02);
    }

    @Test
    public void updateDistances() {
        InitializePlusPlus alg = new InitializePlusPlus();
        alg.init(1, 123L);
        alg.distance.resize(3);
        alg.distance.data = new double[]{3.0, 6.0, 1.0};
        ArrayList<double[]> points = new ArrayList<double[]>();
        for (int i = 0; i < 3; ++i) {
            points.add(new double[]{i * i});
        }
        alg.updateDistances(points, new double[]{-1.0});
        Assert.assertEquals((double)1.0, (double)alg.distance.get(0), (double)1.0E-8);
        Assert.assertEquals((double)4.0, (double)alg.distance.get(1), (double)1.0E-8);
        Assert.assertEquals((double)1.0, (double)alg.distance.get(2), (double)1.0E-8);
        Assert.assertEquals((double)6.0, (double)alg.totalDistance, (double)1.0E-8);
    }

    @Override
    public InitializeKMeans_F64 createAlg() {
        return new InitializePlusPlus();
    }
}

