/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.kmeans;

import java.util.Arrays;
import java.util.List;
import org.ddogleg.clustering.kmeans.InitializeKMeans_F64;
import org.ddogleg.clustering.kmeans.TestStandardKMeans_F64;
import org.junit.Assert;
import org.junit.Test;

public abstract class StandardInitializeKMeansChecks {
    public abstract InitializeKMeans_F64 createAlg();

    @Test
    public void selectSeeds() {
        int DOF = 20;
        InitializeKMeans_F64 alg = this.createAlg();
        alg.init(DOF, 48879L);
        List<double[]> points = TestStandardKMeans_F64.createPoints(DOF, 100, true);
        List<double[]> seeds = TestStandardKMeans_F64.createPoints(DOF, 20, false);
        alg.selectSeeds(points, seeds);
        Assert.assertEquals((long)20L, (long)seeds.size());
        for (int i = 0; i < seeds.size(); ++i) {
            int j;
            double[] s = seeds.get(i);
            for (j = 0; j < DOF; ++j) {
                Assert.assertTrue((s[j] != 0.0 ? 1 : 0) != 0);
            }
            for (j = 0; j < points.size(); ++j) {
                Assert.assertTrue((points.get(j) != s ? 1 : 0) != 0);
            }
        }
    }

    @Test
    public void impossible() {
        try {
            int DOF = 20;
            InitializeKMeans_F64 alg = this.createAlg();
            alg.init(DOF, 48879L);
            List<double[]> points = TestStandardKMeans_F64.createPoints(DOF, 3, true);
            List<double[]> seeds = TestStandardKMeans_F64.createPoints(DOF, 4, false);
            alg.selectSeeds(points, seeds);
            Assert.fail((String)"Should have thrown an exception!");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void uniqueSeeds() {
        this.uniqueSeeds(4, 4);
        this.uniqueSeeds(10, 4);
    }

    public void uniqueSeeds(int numPoints, int numSeeds) {
        int DOF = 20;
        InitializeKMeans_F64 alg = this.createAlg();
        alg.init(DOF, 48879L);
        List<double[]> points = TestStandardKMeans_F64.createPoints(DOF, numPoints, true);
        List<double[]> seeds = TestStandardKMeans_F64.createPoints(DOF, numSeeds, false);
        boolean[] matched = new boolean[4];
        for (int i = 0; i < 30; ++i) {
            alg.selectSeeds(points, seeds);
            Assert.assertEquals((long)numPoints, (long)points.size());
            Assert.assertEquals((long)numSeeds, (long)seeds.size());
            Arrays.fill(matched, false);
            for (int j = 0; j < seeds.size(); ++j) {
                double[] a = seeds.get(j);
                for (int k = j + 1; k < seeds.size(); ++k) {
                    double[] b = seeds.get(k);
                    boolean identical = true;
                    for (int l = 0; l < a.length; ++l) {
                        if (a[l] == b[l]) continue;
                        identical = false;
                        break;
                    }
                    if (!identical) continue;
                    Assert.fail((String)"Seed is not unique");
                }
            }
        }
    }
}

