/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering.gmm;

import java.util.Random;
import org.ddogleg.clustering.gmm.GaussianGmm_F64;
import org.ejml.data.DenseMatrix64F;
import org.ejml.equation.Equation;
import org.ejml.ops.CommonOps;
import org.ejml.ops.MatrixFeatures;
import org.ejml.ops.RandomMatrices;
import org.junit.Assert;
import org.junit.Test;

public class TestGaussianGmm_F64 {
    Random rand = new Random(234L);

    @Test
    public void zero() {
        GaussianGmm_F64 g = new GaussianGmm_F64(3);
        CommonOps.fill(g.mean, 1.0);
        CommonOps.fill(g.covariance, 2.0);
        g.weight = 4.0;
        g.zero();
        Assert.assertTrue((CommonOps.elementSumAbs(g.mean) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((CommonOps.elementSumAbs(g.covariance) == 0.0 ? 1 : 0) != 0);
        Assert.assertTrue((g.weight == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void addMean() {
        GaussianGmm_F64 g = new GaussianGmm_F64(3);
        g.addMean(new double[]{2.0, 3.0, -1.0}, 0.7);
        g.addMean(new double[]{4.0, 1.0, 0.5}, 1.2);
        Assert.assertEquals((double)6.199999999999999, (double)g.mean.data[0], (double)1.0E-8);
        Assert.assertEquals((double)3.3, (double)g.mean.data[1], (double)1.0E-8);
        Assert.assertEquals((double)-0.09999999999999998, (double)g.mean.data[2], (double)1.0E-8);
        Assert.assertEquals((double)1.9, (double)g.weight, (double)1.0E-8);
    }

    @Test
    public void addCovariance() {
        GaussianGmm_F64 g = new GaussianGmm_F64(3);
        g.setMean(new double[]{4.0, 3.0, 6.0});
        Equation eq = new Equation();
        eq.process("Q = zeros(3,3)");
        for (int i = 0; i < 5; ++i) {
            DenseMatrix64F x = RandomMatrices.createRandom(3, 1, this.rand);
            eq.alias(x, "x", 0.4 + (double)i * 0.1, "w");
            eq.process("Q = Q + w*x*x'");
            g.addCovariance(x.data, 0.4 + (double)i * 0.1);
        }
        DenseMatrix64F Q = eq.lookupMatrix("Q");
        Assert.assertTrue((boolean)MatrixFeatures.isIdentical(Q, g.covariance, 1.0E-8));
    }

    @Test
    public void setMean() {
        GaussianGmm_F64 g = new GaussianGmm_F64(3);
        g.setMean(new double[]{1.0, 2.0, 3.0});
        for (int i = 0; i < 3; ++i) {
            Assert.assertEquals((double)(i + 1), (double)g.mean.get(i, 0), (double)1.0E-8);
        }
    }
}

