/*
 * Decompiled with CFR 0.152.
 */
package org.ddogleg.clustering;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;

public class BenchmarkBulkDistance {
    Random rand = new Random(234L);
    int DOF = 100;
    int numPoints = 100000;
    int numClusters = 300;
    List<double[]> centers = new ArrayList<double[]>();
    List<double[]> points = new ArrayList<double[]>();

    public long standard(int[] assignments, int numIterations) {
        long timeStart = System.currentTimeMillis();
        for (int i = 0; i < numIterations; ++i) {
            for (int j = 0; j < this.points.size(); ++j) {
                double[] p = this.points.get(j);
                int best = -1;
                double bestDistance = Double.MAX_VALUE;
                for (int k = 0; k < this.centers.size(); ++k) {
                    double[] c = this.centers.get(k);
                    double d = 0.0;
                    for (int l = 0; l < c.length; ++l) {
                        double x = c[l] - p[l];
                        d += x * x;
                    }
                    if (!(d < bestDistance)) continue;
                    bestDistance = d;
                    best = k;
                }
                int n = best;
                assignments[n] = assignments[n] + 1;
            }
        }
        long timeStop = System.currentTimeMillis();
        return timeStop - timeStart;
    }

    public long bulk(int[] assignments, int numIterations) {
        int N = this.points.get(0).length;
        double[] array = new double[this.centers.size() * N];
        for (int i = 0; i < this.centers.size(); ++i) {
            double[] c = this.centers.get(i);
            System.arraycopy(c, 0, array, i * N, N);
        }
        double[] distances = new double[this.centers.size()];
        long timeStart = System.currentTimeMillis();
        for (int i = 0; i < numIterations; ++i) {
            for (int j = 0; j < this.points.size(); ++j) {
                double[] p = this.points.get(j);
                int best = -1;
                double bestDistance = Double.MAX_VALUE;
                int index = 0;
                for (int k = 0; k < distances.length; ++k) {
                    double d = 0.0;
                    for (int l = 0; l < N; ++l) {
                        double x = array[index++] - p[l];
                        d += x * x;
                    }
                    if (!(d < bestDistance)) continue;
                    bestDistance = d;
                    best = k;
                }
                int n = best;
                assignments[n] = assignments[n] + 1;
            }
        }
        long timeStop = System.currentTimeMillis();
        return timeStop - timeStart;
    }

    public void process() {
        this.randomSet(this.points, this.numPoints);
        this.randomSet(this.centers, this.numClusters);
        int numIterations = 1;
        int[] assignA = new int[this.numPoints];
        int[] assignB = new int[this.numPoints];
        long timeB = this.bulk(assignB, numIterations);
        long timeA = this.standard(assignA, numIterations);
        System.out.println("Time Standard = " + timeA);
        System.out.println("Time Bulk     = " + timeB);
        for (int i = 0; i < this.numPoints; ++i) {
            if (assignA[i] == assignB[i]) continue;
            throw new RuntimeException("Oh shit");
        }
    }

    private void randomSet(List<double[]> points, int numPoints) {
        for (int i = 0; i < numPoints; ++i) {
            double[] p = new double[this.DOF];
            for (int j = 0; j < this.DOF; ++j) {
                p[j] = this.rand.nextGaussian();
            }
            points.add(p);
        }
    }

    public static void main(String[] args) {
        BenchmarkBulkDistance benchmark = new BenchmarkBulkDistance();
        benchmark.process();
    }
}

