/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

import com.mhuss.AstroLib.Latitude;
import com.mhuss.AstroLib.Longitude;
import com.mhuss.AstroLib.TimeOps;

public class ObsInfo {
    private double m_longitude;
    private double m_latitude;
    private int m_timeZone;

    public ObsInfo() {
        this.m_latitude = 0.0;
        this.m_longitude = 0.0;
        this.m_timeZone = 0;
    }

    public ObsInfo(Latitude lat, Longitude lon, int tz) {
        this.m_latitude = Math.toRadians(lat.value);
        this.m_longitude = Math.toRadians(lon.value);
        this.m_timeZone = tz;
    }

    public ObsInfo(Latitude lat, Longitude lon) {
        this.m_latitude = Math.toRadians(lat.value);
        this.m_longitude = Math.toRadians(lon.value);
        this.m_timeZone = TimeOps.tzOffset();
    }

    public double getLatitudeDeg() {
        return Math.toDegrees(this.m_latitude);
    }

    public double getLatitudeRad() {
        return this.m_latitude;
    }

    public void setLatitudeDeg(double lat) {
        this.m_latitude = Math.toRadians(lat);
    }

    public void setLatitudeRad(double lat) {
        this.m_latitude = lat;
    }

    public double getLongitudeDeg() {
        return Math.toDegrees(this.m_longitude);
    }

    public double getLongitudeRad() {
        return this.m_longitude;
    }

    public void setLongitudeDeg(double lon) {
        this.m_longitude = Math.toRadians(lon);
    }

    public void setLongitudeRad(double lon) {
        this.m_longitude = lon;
    }

    public int getTimeZone() {
        return this.m_timeZone;
    }

    public void setTimeZone(int tz) {
        this.m_timeZone = tz;
    }
}

