/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

public class AtlasRef {
    public static int millenniumAtlasPage(double ra, double dec) {
        int page;
        if (dec >= 87.0) {
            page = ra < 4.0 || ra > 16.0 ? 2 : 1;
        } else if (dec <= -87.0) {
            page = ra < 4.0 || ra > 16.0 ? 516 : 515;
        } else {
            int gore = (int)(ra / 8.0);
            int zone = (int)((93.0 - dec) / 6.0);
            double remains = Math.ceil(ra / 8.0) * 8.0 - ra;
            int[] per_zone = new int[]{2, 4, 8, 10, 12, 14, 16, 20, 20, 22, 22, 24, 24, 24, 24, 24, 24, 24, 24, 24, 22, 22, 20, 20, 16, 14, 12, 10, 8, 4, 2};
            page = (int)(remains * (double)per_zone[zone] / 8.0) + 1 + gore * 516;
            while (0 != zone--) {
                page += per_zone[zone];
            }
        }
        return page;
    }

    public static int skyAtlasPage(double ra, double dec) {
        int page;
        if (Math.abs(dec) < 18.5) {
            page = 9 + (int)(ra / 3.0 + 0.8333333333333334);
            if (page == 9) {
                page = 17;
            }
        } else if (Math.abs(dec) < 52.0) {
            page = 4 + (int)(ra / 4.0);
            if (dec < 0.0) {
                page += 14;
            }
        } else {
            page = 1 + (int)(ra / 8.0);
            if (dec < 0.0) {
                page += 23;
            }
        }
        return page;
    }

    public static int uranometriaPage(double ra, double dec, boolean fix472) {
        int[] decLimits = new int[]{-900, -845, -725, -610, -500, -390, -280, -170, -55, 55, 170, 280, 390, 500, 610, 725, 845, 900};
        int[] nDivides = new int[]{2, 12, 20, 24, 30, 36, 45, 45, 45, 45, 45, 36, 30, 24, 20, 12, 2};
        int startValue = 472;
        int divide = 0;
        while ((double)decLimits[divide + 1] < dec * 10.0) {
            startValue -= nDivides[divide + 1];
            ++divide;
        }
        double angle = ra * (double)nDivides[divide] / 24.0;
        if (nDivides[divide] >= 20) {
            angle += 0.5;
        } else if (nDivides[divide] == 12) {
            angle += 0.4166666666666667;
        }
        int page = (int)angle % nDivides[divide] + startValue;
        if (page >= 472 && fix472) {
            page = 945 - page;
        }
        return page;
    }

    public static int uranometriaPage(double ra, double dec) {
        return AtlasRef.uranometriaPage(ra, dec, true);
    }

    public static String ruklPage(double lon, double lat) {
        double x = Math.cos(lat) * Math.cos(lon);
        double y = Math.cos(lat) * Math.sin(lon);
        double z = Math.sin(lat);
        int page = -1;
        int ix = (int)(y * 5.5 + 5.5);
        int iy = (int)(4.0 - 4.0 * z);
        int[] page_starts = new int[]{-1, 7, 17, 28, 39, 50, 60, 68};
        StringBuffer buff = new StringBuffer("Rukl ");
        if (x > 0.0) {
            if (iy <= 1 || iy >= 6) {
                if (0 == ix) {
                    ix = 1;
                } else if (10 == ix) {
                    ix = 9;
                }
            }
            if (0 == iy || 7 == iy) {
                if (1 == ix) {
                    ix = 2;
                } else if (9 == ix) {
                    ix = 8;
                }
            }
            page = ix + page_starts[iy];
            buff.append(page);
        }
        if (x < 0.13962634015954636 && x > -0.13962634015954636) {
            int zone_no = (int)(Math.atan2(z, y) * 4.0 / Math.PI + 4.0);
            String[] librationZonePages = new String[]{"VII", "VI", "V", "IV", "III", "II", "I", "VIII"};
            if (page > -1) {
                buff.append('/');
            }
            buff.append(librationZonePages[zone_no]);
        }
        return -1 == page ? "" : buff.toString();
    }
}

