/*
 * Decompiled with CFR 0.152.
 */
package com.mhuss.AstroLib;

public class AstroOps {
    public static double meanObliquity(double t) {
        double rval = 0.0;
        double t0 = 30000.0;
        double rvalStart = 84381.448;
        int OBLIQ_COEFFS = 10;
        double[] coeffs = new double[]{-468093.0, -155.0, 199925.0, -5138.0, -24967.0, -3905.0, 712.0, 2787.0, 579.0, 245.0};
        if (t0 != t) {
            double u0;
            t0 = t;
            double u = u0 = t / 100.0;
            rval = 84381.448;
            for (int i = 0; i < 10; ++i) {
                rval += u * coeffs[i] / 100.0;
                u *= u0;
            }
            rval = Math.toRadians(rval / 3600.0);
        }
        return rval;
    }

    public static double greenwichSiderealTime(double jd) {
        double jdm = (jd -= 2451545.0) / 36525.0;
        double intPart = Math.floor(jd);
        double rval = 280.46061837 + 360.98564736629 * (jd -= intPart) + 0.98564736629 * intPart + jdm * jdm * (3.87933E-4 - jdm / 3.871E7);
        return Math.toRadians(rval);
    }

    public static double toDays(int hours) {
        return (double)hours / 24.0;
    }

    public static double toMillenia(double jd) {
        return (jd - 2451545.0) / 36525.0;
    }

    public static double normalizeDegrees(double d) {
        if ((d -= 360.0 * Math.floor(d / 360.0)) < 0.0) {
            d += 360.0;
        }
        return d;
    }

    public static double normalizeRadians(double r) {
        if ((r -= Math.PI * 2 * Math.floor(r / (Math.PI * 2))) < 0.0) {
            r += Math.PI * 2;
        }
        return r;
    }

    public static int quadrant(double radians) {
        return (int)(AstroOps.normalizeRadians(radians) * 0.6366197723675814);
    }
}

