/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.util.HashMap;
import java.util.Map;
import java.util.Random;
import org.uncommons.maths.demo.ProbabilityDistribution;
import org.uncommons.maths.random.DiscreteUniformGenerator;

class UniformDistribution
extends ProbabilityDistribution {
    private final int min;
    private final int max;

    public UniformDistribution(int min, int max) {
        this.min = min;
        this.max = max;
    }

    @Override
    public Map<Double, Double> getExpectedValues() {
        HashMap<Double, Double> values = new HashMap<Double, Double>();
        for (int i = this.min; i <= this.max; ++i) {
            values.put(Double.valueOf(i), 1.0 / (double)(this.max - this.min + 1));
        }
        return values;
    }

    protected DiscreteUniformGenerator createValueGenerator(Random rng) {
        return new DiscreteUniformGenerator(this.min, this.max, rng);
    }

    @Override
    public double getExpectedMean() {
        return (this.max - this.min) / 2 + this.min;
    }

    @Override
    public double getExpectedStandardDeviation() {
        return (double)(this.max - this.min) / Math.sqrt(12.0);
    }

    @Override
    public String getDescription() {
        return "Uniform Distribution (Range = " + this.min + "..." + this.max + ")";
    }

    @Override
    public boolean isDiscrete() {
        return true;
    }
}

