/*
 * Decompiled with CFR 0.152.
 */
package org.uncommons.maths.demo;

import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSpinner;
import javax.swing.SpinnerNumberModel;
import javax.swing.SpringLayout;
import org.uncommons.maths.demo.GaussianDistribution;
import org.uncommons.maths.demo.ParametersPanel;
import org.uncommons.swing.SpringUtilities;

class GaussianParametersPanel
extends ParametersPanel {
    private final SpinnerNumberModel meanNumberModel = new SpinnerNumberModel(0, -1000, 1000, 1);
    private final SpinnerNumberModel deviationNumberModel = new SpinnerNumberModel(1.0, 0.01, 1000.0, 1.0);

    public GaussianParametersPanel() {
        JPanel wrapper = new JPanel(new SpringLayout());
        wrapper.add(new JLabel("Mean: "));
        wrapper.add(new JSpinner(this.meanNumberModel));
        wrapper.add(new JLabel("Standard Deviation: "));
        wrapper.add(new JSpinner(this.deviationNumberModel));
        SpringUtilities.makeCompactGrid(wrapper, 4, 1, 6, 6, 6, 6);
        this.add((Component)wrapper, "North");
    }

    @Override
    public GaussianDistribution createProbabilityDistribution() {
        return new GaussianDistribution(this.meanNumberModel.getNumber().doubleValue(), this.deviationNumberModel.getNumber().doubleValue());
    }
}

