/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial.groebner;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Debug;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;
import jscl.math.polynomial.groebner.Pair;
import jscl.math.polynomial.groebner.Projection;
import jscl.math.polynomial.groebner.ReducedRowEchelonForm;

class F4Reduction {
    final Collection ideal;
    final List list;
    final int flags;
    final List polys = new ArrayList();
    final List content = new ArrayList();
    final Map considered = new TreeMap();
    final Map head = new TreeMap();
    final Map proj = new TreeMap();

    F4Reduction(Collection ideal, List list, int flags) {
        this.ideal = ideal;
        this.list = list;
        this.flags = flags;
    }

    static List compute(List pairs, Collection ideal, List list, int flags) {
        F4Reduction r = new F4Reduction(ideal, list, flags);
        r.compute(pairs);
        return r.content;
    }

    void compute(List pairs) {
        for (Pair pa : pairs) {
            this.considered.put(pa.scm, null);
            this.add(pa);
        }
        this.process();
        if ((this.flags & 0x2000) > 0) {
            this.list.add(this);
        }
    }

    void add(Pair pair) {
        Debug.println(pair);
        Projection[] pr = new Projection[]{new Projection(pair, 0), new Projection(pair, 1)};
        for (int i = 0; i < pr.length; ++i) {
            if (this.proj.containsKey(pr[i])) continue;
            this.add(pr[i].simplify(this.list));
            this.proj.put(pr[i], null);
        }
    }

    void add(Projection projection) {
        Polynomial p = projection.mult();
        Monomial scm = projection.scm();
        this.head.put(scm, null);
        Iterator it = p.iterator(scm);
        block0: while (it.hasNext()) {
            Term t = (Term)it.next();
            Monomial m1 = t.monomial();
            if (this.considered.containsKey(m1)) continue;
            this.considered.put(m1, null);
            for (Polynomial q : this.ideal) {
                Monomial m2 = q.head().monomial();
                if (!m1.multiple(m2)) continue;
                Monomial m = m1.divide(m2);
                this.add(new Projection(m, q).simplify(this.list));
                continue block0;
            }
        }
        this.content.add(p);
    }

    void process() {
        List list = ReducedRowEchelonForm.compute(this.content);
        this.content.clear();
        int n = list.size();
        for (int i = 0; i < n; ++i) {
            Polynomial p = (Polynomial)list.get(i);
            if (p.signum() == 0) continue;
            Monomial m = p.head().monomial();
            if (!this.head.containsKey(m)) {
                this.content.add(p);
                continue;
            }
            if (p.index() != -1) {
                p = p.copy();
            }
            p.setIndex(this.polys.size());
            this.polys.add(p);
        }
    }
}

