/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Ordering;

class MonomialIterator
implements Iterator {
    static final Ordering ordering = Monomial.iteratorOrdering;
    Monomial monomial;
    Monomial current;
    boolean carry;

    MonomialIterator(Monomial beginning, Monomial monomial) {
        this.monomial = monomial;
        this.current = monomial.valueof(beginning);
        if (ordering.compare(this.current, monomial) > 0) {
            this.carry = true;
        }
    }

    @Override
    public boolean hasNext() {
        return !this.carry;
    }

    public Object next() {
        Monomial m = this.monomial.valueof(this.current);
        if (ordering.compare(this.current, this.monomial) < 0) {
            this.increment();
        } else {
            this.carry = true;
        }
        return m;
    }

    void increment() {
        int n;
        int s = 0;
        for (n = 0; n < this.current.element.length && this.current.element[n] == 0; ++n) {
        }
        if (n < this.current.element.length) {
            s = this.current.element[n];
            this.current.element[n] = 0;
            ++n;
        }
        if (n < this.current.element.length) {
            int n2 = n;
            this.current.element[n2] = this.current.element[n2] + 1;
            this.fill(s - 1);
        } else {
            ++this.current.degree;
            this.fill(s + 1);
        }
    }

    private void fill(int s) {
        this.current.element[0] = s;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException();
    }
}

