/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;
import jscl.mathml.MathML;

final class GeoBucket
extends Polynomial {
    final Polynomial factory;
    Polynomial[] content;
    int size;
    boolean mutable = true;
    boolean canonicalized = true;

    GeoBucket(Polynomial factory) {
        super(factory.monomialFactory, factory.coefFactory);
        this.factory = factory;
    }

    GeoBucket(int size, Polynomial factory) {
        this(factory);
        this.init(size);
    }

    @Override
    public int size() {
        return this.size;
    }

    void init(int size) {
        this.content = new Polynomial[size];
        this.size = size;
    }

    void resize(int size) {
        Polynomial[] content = new Polynomial[size];
        System.arraycopy(this.content, 0, content, 0, Math.min(this.size, size));
        this.content = content;
        this.size = size;
    }

    @Override
    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    Term behead(Term t, int n, int i) {
        Monomial m = t.monomial();
        Polynomial p = this.factory.valueof(m).multiply(t.coef());
        this.content[n] = this.content[n].subtract(p);
        this.content[i] = this.content[i].add(p);
        return new Term(m, this.content[i].coefficient(m));
    }

    void canonicalize() {
        Polynomial s = this.factory.valueof(JSCLInteger.valueOf(0L));
        int sugar = 0;
        for (int i = 0; i < this.size; ++i) {
            Polynomial p = this.content[i];
            if (p == null) continue;
            s = s.add(p);
            sugar = Math.max(sugar, p.sugar());
            this.content[i] = null;
        }
        this.resize(GeoBucket.log(s.size()) + 1);
        this.set(s.normalize());
        this.canonicalized = true;
        this.setSugar(sugar);
        this.mutable = false;
    }

    static int log(int n) {
        int i = 0;
        while (n > 3) {
            ++i;
            n >>= 2;
        }
        return i;
    }

    Polynomial polynomial() {
        if (this.canonicalized) {
            return this.content[this.size - 1];
        }
        throw new UnsupportedOperationException();
    }

    void set(Polynomial polynomial) {
        this.content[this.size - 1] = polynomial;
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        if (this.mutable) {
            Polynomial p;
            Polynomial q = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(q.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial s = ((p = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : p).subtract(q);
            this.content[n] = null;
            while (n < GeoBucket.log(s.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((p = this.content[n]) != null) {
                    s = p.add(s);
                }
                this.content[n] = null;
            }
            this.content[n] = s;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (this.mutable) {
            Polynomial p;
            Polynomial q = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(q.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial s = ((p = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : p).multiplyAndSubtract(generic, q);
            this.content[n] = null;
            while (n < GeoBucket.log(s.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((p = this.content[n]) != null) {
                    s = p.add(s);
                }
                this.content[n] = null;
            }
            this.content[n] = s;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(generic, polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (this.mutable) {
            Polynomial p;
            Polynomial q = ((GeoBucket)polynomial).polynomial();
            int n = GeoBucket.log(q.size());
            if (n >= this.size) {
                this.resize(n + 1);
            }
            Polynomial s = ((p = this.content[n]) == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : p).multiplyAndSubtract(monomial, generic, q);
            this.content[n] = null;
            while (n < GeoBucket.log(s.size())) {
                if (++n >= this.size) {
                    this.resize(n + 1);
                }
                if ((p = this.content[n]) != null) {
                    s = p.add(s);
                }
                this.content[n] = null;
            }
            this.content[n] = s;
            this.canonicalized = false;
            this.normalized = false;
            return this;
        }
        return this.copy().multiplyAndSubtract(monomial, generic, polynomial);
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (this.mutable) {
            if (this.canonicalized) {
                this.set(this.polynomial().multiply(generic));
            } else {
                for (int i = 0; i < this.size; ++i) {
                    Polynomial p = this.content[i];
                    if (p == null) continue;
                    this.content[i] = p.multiply(generic);
                }
            }
            this.normalized = false;
            return this;
        }
        return this.copy().multiply(generic);
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.mutable) {
            this.set(this.polynomial().multiply(monomial));
            return this;
        }
        return this.copy().multiply(monomial);
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (this.mutable) {
            if (this.canonicalized) {
                this.set(this.polynomial().divide(generic));
            } else {
                for (int i = 0; i < this.size; ++i) {
                    Polynomial p = this.content[i];
                    if (p == null) continue;
                    this.content[i] = p.divide(generic);
                }
            }
            this.normalized = false;
            return this;
        }
        return this.copy().divide(generic);
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (this.mutable) {
            this.set(this.polynomial().divide(monomial));
            return this;
        }
        return this.copy().divide(monomial);
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        return this.canonicalized ? this.polynomial().gcd() : this.coefficient(JSCLInteger.valueOf(0L));
    }

    @Override
    public int degree() {
        return this.polynomial().degree();
    }

    public Polynomial valueof(GeoBucket bucket) {
        return this.valueof(bucket.polynomial().copy());
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        if (polynomial instanceof GeoBucket) {
            return this.valueof((GeoBucket)polynomial);
        }
        GeoBucket b = new GeoBucket(GeoBucket.log(polynomial.size()) + 1, this.factory);
        b.set(polynomial);
        return b;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        return this.valueof(this.factory.valueof(generic));
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        return this.valueof(this.factory.valueof(monomial));
    }

    @Override
    public Polynomial freeze() {
        this.canonicalize();
        return this;
    }

    @Override
    public Term head() {
        return this.canonicalized ? this.polynomial().head() : super.head();
    }

    @Override
    public Term tail() {
        return this.canonicalized ? this.polynomial().tail() : super.tail();
    }

    @Override
    public Generic coefficient(Monomial monomial) {
        return this.canonicalized ? this.polynomial().coefficient(monomial) : super.coefficient(monomial);
    }

    @Override
    public int sugar() {
        return this.polynomial().sugar();
    }

    @Override
    public int index() {
        return this.polynomial().index();
    }

    @Override
    public void setSugar(int n) {
        this.polynomial().setSugar(n);
    }

    @Override
    public void setIndex(int n) {
        this.polynomial().setIndex(n);
    }

    @Override
    public Generic genericValue() {
        return this.polynomial().genericValue();
    }

    @Override
    public Generic[] elements() {
        return this.polynomial().elements();
    }

    public int compareTo(GeoBucket bucket) {
        return this.polynomial().compareTo(bucket.polynomial());
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        return this.compareTo((GeoBucket)polynomial);
    }

    @Override
    public String toString() {
        if (this.canonicalized) {
            return this.polynomial().toString();
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append("{");
        for (int i = 0; i < this.size; ++i) {
            Polynomial p = this.content[i];
            buffer.append(p == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : p).append(i < this.size - 1 ? ", " : "");
        }
        buffer.append("}");
        return buffer.toString();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        if (this.canonicalized) {
            this.polynomial().toMathML(element, data);
        } else {
            MathML e1 = element.element("mfenced");
            MathML e2 = element.element("mtable");
            for (int i = 0; i < this.size; ++i) {
                MathML e3 = element.element("mtr");
                MathML e4 = element.element("mtd");
                Polynomial p = this.content[i];
                (p == null ? this.factory.valueof(JSCLInteger.valueOf(0L)) : p).toMathML(e4, null);
                e3.appendChild(e4);
                e2.appendChild(e3);
            }
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        Term term;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            this.term = new Term(current, GeoBucket.this.coefficient(JSCLInteger.valueOf(0L)));
            this.seek();
        }

        void seek() {
            Term t;
            do {
                int n = 0;
                t = null;
                for (int i = 0; i < GeoBucket.this.size; ++i) {
                    Term u;
                    Polynomial p = GeoBucket.this.content[i];
                    if (p == null) continue;
                    Iterator it = p.iterator(this.direction, this.term.monomial());
                    Term term = u = it.hasNext() ? (Term)it.next() : null;
                    if (u == null) continue;
                    if (t == null || (this.direction ? -1 : 1) * GeoBucket.this.ordering.compare(t.monomial(), u.monomial()) > 0) {
                        t = u;
                        n = i;
                        continue;
                    }
                    if (GeoBucket.this.ordering.compare(t.monomial(), u.monomial()) != 0) continue;
                    t = GeoBucket.this.behead(t, n, i);
                    n = i;
                }
            } while (t != null && t.coef().signum() == 0);
            this.term = t;
        }

        @Override
        public boolean hasNext() {
            return this.term != null;
        }

        public Object next() {
            Term t = this.term;
            this.seek();
            return t;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

