/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Arrays;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import jscl.math.Expression;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.Literal;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;
import jscl.math.polynomial.Term;

class ArrayPolynomialGeneric
extends Polynomial {
    Generic[] coef;
    Monomial[] monomial;
    int size;
    int degree;

    ArrayPolynomialGeneric(Monomial monomialFactory, Generic coefFactory) {
        super(monomialFactory, coefFactory);
    }

    ArrayPolynomialGeneric(int size, Monomial monomialFactory, Generic coefFactory) {
        this(monomialFactory, coefFactory);
        this.init(size);
    }

    @Override
    public int size() {
        return this.size;
    }

    void init(int size) {
        this.monomial = new Monomial[size];
        this.coef = new Generic[size];
        this.size = size;
    }

    void resize(int size) {
        int length = this.monomial.length;
        if (size < length) {
            Monomial[] monomial = new Monomial[size];
            Generic[] coef = new Generic[size];
            System.arraycopy(this.monomial, length - size, monomial, 0, size);
            System.arraycopy(this.coef, length - size, coef, 0, size);
            this.monomial = monomial;
            this.coef = coef;
            this.size = size;
        }
    }

    @Override
    public Iterator iterator(boolean direction, Monomial current) {
        return new ContentIterator(direction, current);
    }

    Term term(final int index) {
        return new Term(this.monomial[index], null){

            @Override
            public Generic coef() {
                return this.coef == null ? ArrayPolynomialGeneric.this.getCoef(index) : this.coef;
            }
        };
    }

    int indexOf(Monomial monomial, boolean direction) {
        if (monomial == null) {
            return direction ? this.size : 0;
        }
        int n = Arrays.binarySearch(this.monomial, monomial, this.ordering);
        return n < 0 ? -n - 1 : (direction ? n : n + 1);
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial m2;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialGeneric q = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            Generic a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.getCoef(i1);
                p.monomial[--i] = m1;
                p.setCoef(i, a);
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.getCoef(i2).negate();
                p.monomial[--i] = m2;
                p.setCoef(i, a);
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = this.getCoef(i1).subtract(q.getCoef(i2));
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.setCoef(i, a);
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialGeneric.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (generic.signum() == 0) {
            return this;
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this.subtract(polynomial);
        }
        ArrayPolynomialGeneric q = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            Generic a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.getCoef(i1);
                p.monomial[--i] = m1;
                p.setCoef(i, a);
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.getCoef(i2).multiply(generic).negate();
                p.monomial[--i] = m2;
                p.setCoef(i, a);
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            a = this.getCoef(i1).subtract(q.getCoef(i2).multiply(generic));
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.setCoef(i, a);
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialGeneric.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        Monomial m2;
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (generic.signum() == 0) {
            return this;
        }
        if (monomial.degree() == 0) {
            return this.multiplyAndSubtract(generic, polynomial);
        }
        ArrayPolynomialGeneric q = (ArrayPolynomialGeneric)polynomial;
        ArrayPolynomialGeneric p = this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial2 = m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        while (m1 != null || m2 != null) {
            Generic a;
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                a = this.getCoef(i1);
                p.monomial[--i] = m1;
                p.setCoef(i, a);
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                a = q.getCoef(i2).multiply(generic).negate();
                p.monomial[--i] = m2;
                p.setCoef(i, a);
                m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
                continue;
            }
            a = this.getCoef(i1).subtract(q.getCoef(i2).multiply(generic));
            if (a.signum() != 0) {
                p.monomial[--i] = m1;
                p.setCoef(i, a);
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2].multiply(monomial) : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialGeneric.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar + monomial.degree());
        return p;
    }

    @Override
    public Polynomial multiply(Polynomial polynomial) {
        Polynomial p = this.newinstance(0);
        for (int i = 0; i < this.size; ++i) {
            p = ((Polynomial)p).multiplyAndSubtract(this.monomial[i], this.getCoef(i).negate(), polynomial);
        }
        return p;
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialGeneric p = this.newinstance(this.size);
        System.arraycopy(this.monomial, 0, p.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            p.setCoef(i, this.getCoef(i).multiply(generic));
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            throw new UnsupportedOperationException();
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialGeneric p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i].multiply(monomial);
            p.setCoef(i, this.getCoef(i));
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    @Override
    public Polynomial divide(Generic generic) throws ArithmeticException {
        if (generic.compareTo(JSCLInteger.valueOf(1L)) == 0) {
            return this;
        }
        ArrayPolynomialGeneric p = this.newinstance(this.size);
        System.arraycopy(this.monomial, 0, p.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            p.setCoef(i, this.getCoef(i).divide(generic));
        }
        p.degree = this.degree;
        p.sugar = this.sugar;
        return p;
    }

    @Override
    public Polynomial divide(Monomial monomial) throws ArithmeticException {
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialGeneric p = this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i].divide(monomial);
            p.setCoef(i, this.getCoef(i));
        }
        p.degree = this.degree - monomial.degree();
        p.sugar = this.sugar - monomial.degree();
        return p;
    }

    @Override
    public Polynomial gcd(Polynomial polynomial) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Generic gcd() {
        if (this.field) {
            return this.coefficient(this.tail());
        }
        Generic a = this.coefficient(JSCLInteger.valueOf(0L));
        for (int i = this.size - 1; i >= 0; --i) {
            a = a.gcd(this.getCoef(i));
        }
        return a.signum() == this.signum() ? a : a.negate();
    }

    @Override
    public Monomial monomialGcd() {
        Monomial m = this.monomial(this.tail());
        for (int i = 0; i < this.size; ++i) {
            m = m.gcd(this.monomial[i]);
        }
        return m;
    }

    @Override
    public int degree() {
        return this.degree;
    }

    @Override
    public Polynomial valueof(Polynomial polynomial) {
        ArrayPolynomialGeneric p = this.newinstance(0);
        p.init(polynomial);
        return p;
    }

    @Override
    public Polynomial valueof(Generic generic) {
        ArrayPolynomialGeneric p = this.newinstance(0);
        p.init(generic);
        return p;
    }

    @Override
    public Polynomial valueof(Monomial monomial) {
        ArrayPolynomialGeneric p = this.newinstance(0);
        p.init(monomial);
        return p;
    }

    @Override
    public Polynomial freeze() {
        return this;
    }

    @Override
    public Term head() {
        return this.size > 0 ? this.term(this.size - 1) : null;
    }

    @Override
    public Term tail() {
        return this.size > 0 ? this.term(0) : null;
    }

    protected Generic getCoef(int n) {
        return this.coef[n];
    }

    protected void setCoef(int n, Generic generic) {
        this.coef[n] = generic;
    }

    @Override
    public Generic genericValue() {
        Generic s = JSCLInteger.valueOf(0L);
        for (int i = 0; i < this.size; ++i) {
            Monomial m = this.monomial[i];
            Expression a = this.getCoef(i).expressionValue();
            s = ((Generic)s).add(m.degree() > 0 ? ((Generic)a).multiply(Expression.valueOf(m.literalValue())) : a);
        }
        return s;
    }

    @Override
    public Generic[] elements() {
        Generic[] a = new Generic[this.size];
        for (int i = 0; i < this.size; ++i) {
            a[i] = this.getCoef(i);
        }
        return a;
    }

    @Override
    public int compareTo(Polynomial polynomial) {
        Monomial m2;
        ArrayPolynomialGeneric q = (ArrayPolynomialGeneric)polynomial;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 == 0 ? null : this.monomial[--i1];
        Monomial monomial = m2 = i2 == 0 ? null : q.monomial[--i2];
        while (m1 != null || m2 != null) {
            int c;
            int n = m1 == null ? -1 : (c = m2 == null ? 1 : this.ordering.compare(m1, m2));
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            c = this.getCoef(i1).compareTo(q.getCoef(i2));
            if (c < 0) {
                return -1;
            }
            if (c > 0) {
                return 1;
            }
            m1 = i1 == 0 ? null : this.monomial[--i1];
            m2 = i2 == 0 ? null : q.monomial[--i2];
        }
        return 0;
    }

    void init(Polynomial polynomial) {
        ArrayPolynomialGeneric q = (ArrayPolynomialGeneric)polynomial;
        this.init(q.size);
        System.arraycopy(q.monomial, 0, this.monomial, 0, this.size);
        for (int i = 0; i < this.size; ++i) {
            this.setCoef(i, q.getCoef(i));
        }
        this.degree = q.degree;
        this.sugar = q.sugar;
    }

    void init(Expression expression) {
        TreeMap<Monomial, Generic> map = new TreeMap<Monomial, Generic>(this.ordering);
        int n = expression.size();
        for (int i = 0; i < n; ++i) {
            Generic a;
            Literal l = expression.literal(i);
            JSCLInteger en = expression.coef(i);
            Monomial m = this.monomial(l);
            Generic a2 = this.coefficient((l = l.divide(m.literalValue())).degree() > 0 ? en.multiply(Expression.valueOf(l)) : en);
            Generic a1 = (Generic)map.get(m);
            Generic generic = a = a1 == null ? a2 : a1.add(a2);
            if (a.signum() == 0) {
                map.remove(m);
                continue;
            }
            map.put(m, a);
        }
        this.init(map.size());
        int sugar = 0;
        Iterator it = map.entrySet().iterator();
        for (int i = 0; i < this.size; ++i) {
            Map.Entry e = it.next();
            Monomial m = (Monomial)e.getKey();
            Generic a = (Generic)e.getValue();
            this.monomial[i] = m;
            this.setCoef(i, a);
            sugar = Math.max(sugar, m.degree());
        }
        this.degree = ArrayPolynomialGeneric.degree(this);
        this.sugar = sugar;
    }

    void init(Generic generic) {
        if (generic instanceof Expression) {
            this.init((Expression)generic);
        } else {
            Generic a = this.coefficient(generic);
            if (a.signum() != 0) {
                this.init(1);
                this.monomial[0] = this.monomial(Literal.valueOf());
                this.setCoef(0, a);
            } else {
                this.init(0);
            }
            this.degree = 0;
            this.sugar = 0;
        }
    }

    void init(Monomial monomial) {
        this.init(1);
        this.monomial[0] = monomial;
        this.setCoef(0, this.coefficient(JSCLInteger.valueOf(1L)));
        this.degree = monomial.degree();
        this.sugar = monomial.degree();
    }

    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialGeneric(n, this.monomialFactory, this.coefFactory);
    }

    class ContentIterator
    implements Iterator {
        final boolean direction;
        int index;

        ContentIterator(boolean direction, Monomial current) {
            this.direction = direction;
            this.index = ArrayPolynomialGeneric.this.indexOf(current, direction);
        }

        @Override
        public boolean hasNext() {
            return this.direction ? this.index > 0 : this.index < ArrayPolynomialGeneric.this.size;
        }

        public Object next() {
            return this.direction ? ArrayPolynomialGeneric.this.term(--this.index) : ArrayPolynomialGeneric.this.term(this.index++);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }
}

