/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.polynomial;

import java.util.Iterator;
import java.util.TreeMap;
import jscl.math.Generic;
import jscl.math.JSCLBoolean;
import jscl.math.JSCLInteger;
import jscl.math.polynomial.ArrayPolynomialGeneric;
import jscl.math.polynomial.ArrayPolynomialModular;
import jscl.math.polynomial.Monomial;
import jscl.math.polynomial.Polynomial;

class ArrayPolynomialBoolean
extends ArrayPolynomialModular {
    ArrayPolynomialBoolean(Monomial monomialFactory) {
        super(monomialFactory, JSCLBoolean.factory);
    }

    ArrayPolynomialBoolean(int size, Monomial monomialFactory) {
        this(monomialFactory);
        this.init(size);
    }

    @Override
    void init(int size) {
        this.monomial = new Monomial[size];
        this.size = size;
    }

    @Override
    void resize(int size) {
        int length = this.monomial.length;
        if (size < length) {
            Monomial[] monomial = new Monomial[size];
            System.arraycopy(this.monomial, length - size, monomial, 0, size);
            this.monomial = monomial;
            this.size = size;
        }
    }

    @Override
    public Polynomial subtract(Polynomial polynomial) {
        Monomial m2;
        if (polynomial.signum() == 0) {
            return this;
        }
        ArrayPolynomialBoolean q = (ArrayPolynomialBoolean)polynomial;
        ArrayPolynomialBoolean p = (ArrayPolynomialBoolean)this.newinstance(this.size + q.size);
        int i = p.size;
        int i1 = this.size;
        int i2 = q.size;
        Monomial m1 = i1 > 0 ? this.monomial[--i1] : null;
        Monomial monomial = m2 = i2 > 0 ? q.monomial[--i2] : null;
        while (m1 != null || m2 != null) {
            int c;
            int n = m1 == null ? 1 : (c = m2 == null ? -1 : -this.ordering.compare(m1, m2));
            if (c < 0) {
                p.monomial[--i] = m1;
                m1 = i1 > 0 ? this.monomial[--i1] : null;
                continue;
            }
            if (c > 0) {
                p.monomial[--i] = m2;
                m2 = i2 > 0 ? q.monomial[--i2] : null;
                continue;
            }
            m1 = i1 > 0 ? this.monomial[--i1] : null;
            m2 = i2 > 0 ? q.monomial[--i2] : null;
        }
        p.resize(p.size - i);
        p.degree = ArrayPolynomialBoolean.degree(p);
        p.sugar = Math.max(this.sugar, q.sugar);
        return p;
    }

    @Override
    public Polynomial multiplyAndSubtract(Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        return this.subtract(polynomial);
    }

    @Override
    public Polynomial multiplyAndSubtract(Monomial monomial, Generic generic, Polynomial polynomial) {
        if (generic.signum() == 0) {
            return this;
        }
        return this.multiplyAndSubtract(generic, polynomial.multiply(monomial));
    }

    @Override
    public Polynomial multiply(Generic generic) {
        if (generic.signum() == 0) {
            return this.valueof(JSCLInteger.valueOf(0L));
        }
        return this;
    }

    @Override
    public Polynomial multiply(Monomial monomial) {
        if (this.defined) {
            TreeMap map = new TreeMap(this.ordering);
            for (int i = 0; i < this.size; ++i) {
                Monomial m = this.monomial[i].multiply(monomial);
                if (map.containsKey(m)) {
                    map.remove(m);
                    continue;
                }
                map.put(m, null);
            }
            ArrayPolynomialBoolean p = (ArrayPolynomialBoolean)this.newinstance(map.size());
            Iterator it = map.keySet().iterator();
            for (int i = 0; i < p.size; ++i) {
                p.monomial[i] = (Monomial)it.next();
            }
            p.degree = ArrayPolynomialBoolean.degree(p);
            p.sugar = this.sugar + monomial.degree();
            return p;
        }
        if (monomial.degree() == 0) {
            return this;
        }
        ArrayPolynomialBoolean p = (ArrayPolynomialBoolean)this.newinstance(this.size);
        for (int i = 0; i < this.size; ++i) {
            p.monomial[i] = this.monomial[i].multiply(monomial);
        }
        p.degree = this.degree + monomial.degree();
        p.sugar = this.sugar + monomial.degree();
        return p;
    }

    @Override
    protected Generic getCoef(int n) {
        return new JSCLBoolean(1L);
    }

    @Override
    protected void setCoef(int n, Generic generic) {
    }

    @Override
    protected ArrayPolynomialGeneric newinstance(int n) {
        return new ArrayPolynomialBoolean(n, this.monomialFactory);
    }
}

