/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.operator;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegerException;
import jscl.math.Variable;
import jscl.math.operator.Operator;
import jscl.mathml.MathML;

public class Sum
extends Operator {
    public Sum(Generic expression, Generic variable, Generic n1, Generic n2) {
        super("sum", new Generic[]{expression, variable, n1, n2});
    }

    @Override
    public Generic compute() {
        Variable variable = this.parameter[1].variableValue();
        try {
            int n1 = this.parameter[2].integerValue().intValue();
            int n2 = this.parameter[3].integerValue().intValue();
            Generic a = JSCLInteger.valueOf(0L);
            for (int i = n1; i <= n2; ++i) {
                a = ((Generic)a).add(this.parameter[0].substitute(variable, JSCLInteger.valueOf(i)));
            }
            return a;
        }
        catch (NotIntegerException notIntegerException) {
            return this.expressionValue();
        }
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            MathML e2 = element.element("mfenced");
            this.bodyToMathML(e2);
            e1.appendChild(e2);
            e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        MathML e1 = element.element("mrow");
        MathML e2 = element.element("munderover");
        MathML e3 = element.element("mo");
        e3.appendChild(element.text("\u2211"));
        e2.appendChild(e3);
        e3 = element.element("mrow");
        this.parameter[1].toMathML(e3, null);
        MathML e4 = element.element("mo");
        e4.appendChild(element.text("="));
        e3.appendChild(e4);
        this.parameter[2].toMathML(e3, null);
        e2.appendChild(e3);
        this.parameter[3].toMathML(e2, null);
        e1.appendChild(e2);
        this.parameter[0].toMathML(e1, null);
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Sum(null, null, null, null);
    }
}

