/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.numeric;

import jscl.math.numeric.JSCLDouble;
import jscl.math.numeric.Numeric;

public final class Complex
extends Numeric {
    double real;
    double imag;

    Complex(double real, double imag) {
        this.real = real;
        this.imag = imag;
    }

    public Complex add(Complex complex) {
        return new Complex(this.real + complex.real, this.imag + complex.imag);
    }

    @Override
    public Numeric add(Numeric numeric) {
        if (numeric instanceof Complex) {
            return this.add((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            return this.add(this.valueof(numeric));
        }
        return numeric.valueof(this).add(numeric);
    }

    public Complex subtract(Complex complex) {
        return new Complex(this.real - complex.real, this.imag - complex.imag);
    }

    @Override
    public Numeric subtract(Numeric numeric) {
        if (numeric instanceof Complex) {
            return this.subtract((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            return this.subtract(this.valueof(numeric));
        }
        return numeric.valueof(this).subtract(numeric);
    }

    public Complex multiply(Complex complex) {
        return new Complex(this.real * complex.real - this.imag * complex.imag, this.real * complex.imag + this.imag * complex.real);
    }

    @Override
    public Numeric multiply(Numeric numeric) {
        if (numeric instanceof Complex) {
            return this.multiply((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            return this.multiply(this.valueof(numeric));
        }
        return numeric.multiply(this);
    }

    public Complex divide(Complex complex) throws ArithmeticException {
        return this.multiply((Complex)complex.inverse());
    }

    @Override
    public Numeric divide(Numeric numeric) throws ArithmeticException {
        if (numeric instanceof Complex) {
            return this.divide((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            return this.divide(this.valueof(numeric));
        }
        return numeric.valueof(this).divide(numeric);
    }

    @Override
    public Numeric negate() {
        return new Complex(-this.real, -this.imag);
    }

    @Override
    public int signum() {
        return this.imag == 0.0 ? (this.real == 0.0 ? 0 : (this.real < 0.0 ? -1 : 1)) : (this.imag < 0.0 ? -1 : 1);
    }

    public Complex valueof(Complex complex) {
        return new Complex(complex.real, complex.imag);
    }

    @Override
    public Numeric valueof(Numeric numeric) {
        if (numeric instanceof Complex) {
            return this.valueof((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            JSCLDouble d = (JSCLDouble)numeric;
            return new Complex(d.content, 0.0);
        }
        throw new ArithmeticException();
    }

    public double magnitude() {
        return Math.sqrt(this.real * this.real + this.imag * this.imag);
    }

    public double magnitude2() {
        return this.real * this.real + this.imag * this.imag;
    }

    public double angle() {
        return Math.atan2(this.imag, this.real);
    }

    @Override
    public Numeric log() {
        if (this.signum() == 0) {
            return JSCLDouble.valueOf(0.0).log();
        }
        return new Complex(Math.log(this.magnitude()), this.angle());
    }

    @Override
    public Numeric exp() {
        return new Complex(Math.cos(this.imag), Math.sin(this.imag)).multiply(Math.exp(this.real));
    }

    @Override
    public Numeric inverse() {
        return ((Complex)this.conjugate()).divide(this.magnitude2());
    }

    Complex multiply(double d) {
        return new Complex(this.real * d, this.imag * d);
    }

    Complex divide(double d) {
        return new Complex(this.real / d, this.imag / d);
    }

    @Override
    public Numeric conjugate() {
        return new Complex(this.real, -this.imag);
    }

    public double realPart() {
        return this.real;
    }

    public double imaginaryPart() {
        return this.imag;
    }

    public int compareTo(Complex complex) {
        if (this.imag < complex.imag) {
            return -1;
        }
        if (this.imag > complex.imag) {
            return 1;
        }
        if (this.imag == complex.imag) {
            if (this.real < complex.real) {
                return -1;
            }
            if (this.real > complex.real) {
                return 1;
            }
            if (this.real == complex.real) {
                return 0;
            }
            throw new ArithmeticException();
        }
        throw new ArithmeticException();
    }

    @Override
    public int compareTo(Numeric numeric) {
        if (numeric instanceof Complex) {
            return this.compareTo((Complex)numeric);
        }
        if (numeric instanceof JSCLDouble) {
            return this.compareTo(this.valueof(numeric));
        }
        return numeric.valueof(this).compareTo(numeric);
    }

    public static Complex valueOf(double real, double imag) {
        return new Complex(real, imag);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        if (this.imag == 0.0) {
            buffer.append(this.real);
        } else {
            if (this.real != 0.0) {
                buffer.append(this.real);
                if (!(this.imag <= 0.0)) {
                    buffer.append("+");
                }
            }
            if (this.imag != 1.0) {
                if (this.imag == -1.0) {
                    buffer.append("-");
                } else {
                    buffer.append(this.imag);
                    buffer.append("*");
                }
            }
            buffer.append("sqrt(-1)");
        }
        return buffer.toString();
    }
}

