/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.trigonometric;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Constant;
import jscl.math.function.Frac;
import jscl.math.function.Log;
import jscl.math.function.Trigonometric;
import jscl.math.function.trigonometric.Atan;
import jscl.math.function.trigonometric.Cos;
import jscl.math.function.trigonometric.Sin;

public class Tan
extends Trigonometric {
    public Tan(Generic generic) {
        super("tan", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Log(JSCLInteger.valueOf(4L).multiply(new Cos(this.parameter[0]).evaluate())).evaluate().negate();
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L).add(new Tan(this.parameter[0]).evaluate().pow(2));
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Tan(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.parameter[0].compareTo(Constant.pi) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Frac(new Sin(this.parameter[0]).evalelem(), new Cos(this.parameter[0]).evalelem()).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Tan(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        if (this.parameter[0].compareTo(Constant.pi) == 0) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Atan) {
                Generic[] g = ((Atan)v).parameters();
                return g[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic a, Generic b) {
        Generic ta = new Tan(a).evalsimp();
        Generic tb = new Tan(b).evalsimp();
        return new Frac(ta.add(tb), JSCLInteger.valueOf(1L).subtract(ta.multiply(tb))).evalsimp();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).tan();
    }

    @Override
    protected Variable newinstance() {
        return new Tan(null);
    }
}

