/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function.hyperbolic;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Log;
import jscl.math.function.Trigonometric;
import jscl.math.function.hyperbolic.Atanh;
import jscl.math.function.hyperbolic.Cosh;
import jscl.math.function.hyperbolic.Sinh;

public class Tanh
extends Trigonometric {
    public Tanh(Generic generic) {
        super("tanh", new Generic[]{generic});
    }

    @Override
    public Generic antiderivative(int n) throws NotIntegrableException {
        return new Log(JSCLInteger.valueOf(4L).multiply(new Cosh(this.parameter[0]).evaluate())).evaluate();
    }

    @Override
    public Generic derivative(int n) {
        return JSCLInteger.valueOf(1L).subtract(new Tanh(this.parameter[0]).evaluate().pow(2));
    }

    @Override
    public Generic evaluate() {
        if (this.parameter[0].signum() < 0) {
            return new Tanh(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        return this.expressionValue();
    }

    @Override
    public Generic evalelem() {
        return new Frac(new Sinh(this.parameter[0]).evalelem(), new Cosh(this.parameter[0]).evalelem()).evalelem();
    }

    @Override
    public Generic evalsimp() {
        if (this.parameter[0].signum() < 0) {
            return new Tanh(this.parameter[0].negate()).evaluate().negate();
        }
        if (this.parameter[0].signum() == 0) {
            return JSCLInteger.valueOf(0L);
        }
        try {
            Variable v = this.parameter[0].variableValue();
            if (v instanceof Atanh) {
                Generic[] g = ((Atanh)v).parameters();
                return g[0];
            }
        }
        catch (NotVariableException notVariableException) {
            // empty catch block
        }
        return this.identity();
    }

    @Override
    public Generic identity(Generic a, Generic b) {
        Generic ta = new Tanh(a).evalsimp();
        Generic tb = new Tanh(b).evalsimp();
        return new Frac(ta.add(tb), JSCLInteger.valueOf(1L).add(ta.multiply(tb))).evalsimp();
    }

    @Override
    public Generic evalnum() {
        return ((NumericWrapper)this.parameter[0]).tanh();
    }

    @Override
    protected Variable newinstance() {
        return new Tanh(null);
    }
}

