/*
 * Decompiled with CFR 0.152.
 */
package jscl.math.function;

import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotIntegrableException;
import jscl.math.NumericWrapper;
import jscl.math.Variable;
import jscl.math.function.Exp;
import jscl.math.function.Inv;
import jscl.math.function.Sqrt;
import jscl.mathml.MathML;
import jscl.util.ArrayComparator;

public class Constant
extends Variable {
    public static final Generic e = new Exp(JSCLInteger.valueOf(1L)).expressionValue();
    public static final Generic pi = new Constant("pi").expressionValue();
    public static final Generic i = new Sqrt(JSCLInteger.valueOf(-1L)).expressionValue();
    public static final Generic half = new Inv(JSCLInteger.valueOf(2L)).expressionValue();
    public static final Generic third = new Inv(JSCLInteger.valueOf(3L)).expressionValue();
    public static final Generic j = half.negate().multiply(JSCLInteger.valueOf(1L).subtract(i.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue())));
    public static final Generic jbar = half.negate().multiply(JSCLInteger.valueOf(1L).add(i.multiply(new Sqrt(JSCLInteger.valueOf(3L)).expressionValue())));
    public static final Generic infinity = new Constant("infin").expressionValue();
    static final int PRIMECHARS = 3;
    protected int prime;
    protected Generic[] subscript;

    public Constant(String name) {
        this(name, 0, new Generic[0]);
    }

    public Constant(String name, int prime, Generic[] subscript) {
        super(name);
        this.prime = prime;
        this.subscript = subscript;
    }

    public int prime() {
        return this.prime;
    }

    public Generic[] subscript() {
        return this.subscript;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return null;
    }

    @Override
    public Generic derivative(Variable variable) {
        if (this.isIdentity(variable)) {
            return JSCLInteger.valueOf(1L);
        }
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        Constant v = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            v.subscript[i] = this.subscript[i].substitute(variable, generic);
        }
        if (v.isIdentity(variable)) {
            return generic;
        }
        return v.expressionValue();
    }

    @Override
    public Generic expand() {
        Constant v = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            v.subscript[i] = this.subscript[i].expand();
        }
        return v.expressionValue();
    }

    @Override
    public Generic factorize() {
        Constant v = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            v.subscript[i] = this.subscript[i].factorize();
        }
        return v.expressionValue();
    }

    @Override
    public Generic elementary() {
        Constant v = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            v.subscript[i] = this.subscript[i].elementary();
        }
        return v.expressionValue();
    }

    @Override
    public Generic simplify() {
        Constant v = (Constant)this.newinstance();
        for (int i = 0; i < this.subscript.length; ++i) {
            v.subscript[i] = this.subscript[i].simplify();
        }
        return v.expressionValue();
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public boolean isConstant(Variable variable) {
        return !this.isIdentity(variable);
    }

    @Override
    public int compareTo(Variable variable) {
        if (this == variable) {
            return 0;
        }
        int c = comparator.compare(this, variable);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        Constant v = (Constant)variable;
        c = this.name.compareTo(v.name);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        c = ArrayComparator.comparator.compare(this.subscript, v.subscript);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        if (this.prime < v.prime) {
            return -1;
        }
        if (this.prime > v.prime) {
            return 1;
        }
        return 0;
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        for (int i = 0; i < this.subscript.length; ++i) {
            buffer.append("[").append(this.subscript[i]).append("]");
        }
        if (this.prime != 0) {
            if (this.prime <= 3) {
                buffer.append(Constant.primechars(this.prime));
            } else {
                buffer.append("{").append(this.prime).append("}");
            }
        }
        return buffer.toString();
    }

    static String primechars(int n) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buffer.append("'");
        }
        return buffer.toString();
    }

    @Override
    public String toJava() {
        if (this.compareTo(new Constant("pi")) == 0) {
            return "JSCLDouble.valueOf(Math.PI)";
        }
        if (this.compareTo(new Constant("infin")) == 0) {
            return "JSCLDouble.valueOf(Double.POSITIVE_INFINITY)";
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.name);
        if (this.prime != 0) {
            if (this.prime <= 3) {
                buffer.append(Constant.underscores(this.prime));
            } else {
                buffer.append("_").append(this.prime);
            }
        }
        for (int i = 0; i < this.subscript.length; ++i) {
            buffer.append("[").append(this.subscript[i].integerValue().intValue()).append("]");
        }
        return buffer.toString();
    }

    static String underscores(int n) {
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < n; ++i) {
            buffer.append("_");
        }
        return buffer.toString();
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    public void bodyToMathML(MathML element) {
        if (this.subscript.length == 0) {
            if (this.prime == 0) {
                this.nameToMathML(element);
            } else {
                MathML e1 = element.element("msup");
                this.nameToMathML(e1);
                this.primeToMathML(e1);
                element.appendChild(e1);
            }
        } else if (this.prime == 0) {
            MathML e1 = element.element("msub");
            this.nameToMathML(e1);
            MathML e2 = element.element("mrow");
            for (int i = 0; i < this.subscript.length; ++i) {
                this.subscript[i].toMathML(e2, null);
            }
            e1.appendChild(e2);
            element.appendChild(e1);
        } else {
            MathML e1 = element.element("msubsup");
            this.nameToMathML(e1);
            MathML e2 = element.element("mrow");
            for (int i = 0; i < this.subscript.length; ++i) {
                this.subscript[i].toMathML(e2, null);
            }
            e1.appendChild(e2);
            this.primeToMathML(e1);
            element.appendChild(e1);
        }
    }

    void primeToMathML(MathML element) {
        if (this.prime <= 3) {
            Constant.primecharsToMathML(element, this.prime);
        } else {
            MathML e1 = element.element("mfenced");
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(this.prime)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    static void primecharsToMathML(MathML element, int n) {
        MathML e1 = element.element("mo");
        for (int i = 0; i < n; ++i) {
            e1.appendChild(element.text("\u2032"));
        }
        element.appendChild(e1);
    }

    @Override
    protected Variable newinstance() {
        return new Constant(this.name, this.prime, new Generic[this.subscript.length]);
    }
}

