/*
 * Decompiled with CFR 0.152.
 */
package jscl.math;

import java.math.BigInteger;
import jscl.math.Expression;
import jscl.math.Field;
import jscl.math.Generic;
import jscl.math.JSCLInteger;
import jscl.math.NotExpressionException;
import jscl.math.NotIntegerException;
import jscl.math.NotIntegrableException;
import jscl.math.NotPowerException;
import jscl.math.NotProductException;
import jscl.math.NotVariableException;
import jscl.math.NumericWrapper;
import jscl.math.Power;
import jscl.math.Variable;
import jscl.math.function.Frac;
import jscl.math.function.Inv;
import jscl.mathml.MathML;

public final class Rational
extends Generic
implements Field {
    public static final Rational factory = new Rational(BigInteger.valueOf(0L), BigInteger.valueOf(1L));
    final BigInteger numerator;
    final BigInteger denominator;

    public Rational(BigInteger numerator, BigInteger denominator) {
        this.numerator = numerator;
        this.denominator = denominator;
    }

    public BigInteger numerator() {
        return this.numerator;
    }

    public BigInteger denominator() {
        return this.denominator;
    }

    public Rational add(Rational rational) {
        BigInteger gcd = this.denominator.gcd(rational.denominator);
        BigInteger c = this.denominator.divide(gcd);
        BigInteger c2 = rational.denominator.divide(gcd);
        return new Rational(this.numerator.multiply(c2).add(rational.numerator.multiply(c)), this.denominator.multiply(c2)).reduce();
    }

    Rational reduce() {
        BigInteger gcd = this.numerator.gcd(this.denominator);
        if (gcd.signum() != this.denominator.signum()) {
            gcd = gcd.negate();
        }
        return gcd.signum() == 0 ? this : new Rational(this.numerator.divide(gcd), this.denominator.divide(gcd));
    }

    @Override
    public Generic add(Generic generic) {
        if (generic instanceof Rational) {
            return this.add((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.add(this.valueof(generic));
        }
        return generic.valueof(this).add(generic);
    }

    public Rational multiply(Rational rational) {
        BigInteger gcd = this.numerator.gcd(rational.denominator);
        BigInteger gcd2 = this.denominator.gcd(rational.numerator);
        return new Rational(this.numerator.divide(gcd).multiply(rational.numerator.divide(gcd2)), this.denominator.divide(gcd2).multiply(rational.denominator.divide(gcd)));
    }

    @Override
    public Generic multiply(Generic generic) {
        if (generic instanceof Rational) {
            return this.multiply((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.multiply(this.valueof(generic));
        }
        return generic.multiply(this);
    }

    @Override
    public Generic divide(Generic generic) throws ArithmeticException {
        if (generic instanceof Rational) {
            return this.multiply(generic.inverse());
        }
        if (generic instanceof JSCLInteger) {
            return this.divide(this.valueof(generic));
        }
        return generic.valueof(this).divide(generic);
    }

    @Override
    public Generic inverse() {
        if (this.signum() < 0) {
            return new Rational(this.denominator.negate(), this.numerator.negate());
        }
        return new Rational(this.denominator, this.numerator);
    }

    public Rational gcd(Rational rational) {
        return new Rational(this.numerator.gcd(rational.numerator), Rational.scm(this.denominator, rational.denominator));
    }

    @Override
    public Generic gcd(Generic generic) {
        if (generic instanceof Rational) {
            return this.gcd((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.gcd(this.valueof(generic));
        }
        return generic.valueof(this).gcd(generic);
    }

    static BigInteger scm(BigInteger b1, BigInteger b2) {
        return b1.multiply(b2).divide(b1.gcd(b2));
    }

    @Override
    public Generic gcd() {
        return null;
    }

    @Override
    public Generic pow(int exponent) {
        return null;
    }

    @Override
    public Generic negate() {
        return new Rational(this.numerator.negate(), this.denominator);
    }

    @Override
    public int signum() {
        return this.numerator.signum();
    }

    @Override
    public int degree() {
        return 0;
    }

    @Override
    public Generic antiderivative(Variable variable) throws NotIntegrableException {
        return this.multiply(variable.expressionValue());
    }

    @Override
    public Generic derivative(Variable variable) {
        return JSCLInteger.valueOf(0L);
    }

    @Override
    public Generic substitute(Variable variable, Generic generic) {
        return this;
    }

    @Override
    public Generic expand() {
        return this;
    }

    @Override
    public Generic factorize() {
        return this.expressionValue().factorize();
    }

    @Override
    public Generic elementary() {
        return this;
    }

    @Override
    public Generic simplify() {
        return this.reduce();
    }

    @Override
    public Generic numeric() {
        return new NumericWrapper(this);
    }

    @Override
    public Generic valueof(Generic generic) {
        if (generic instanceof Rational) {
            Rational r = (Rational)generic;
            return new Rational(r.numerator, r.denominator);
        }
        if (generic instanceof Expression) {
            boolean sign = generic.signum() < 0;
            Generic[] g = ((Frac)(sign ? generic.negate() : generic).variableValue()).parameters();
            JSCLInteger numerator = (JSCLInteger)(sign ? g[0].negate() : g[0]);
            JSCLInteger denominator = (JSCLInteger)g[1];
            return new Rational(numerator.content(), denominator.content());
        }
        JSCLInteger en = (JSCLInteger)generic;
        return new Rational(en.content(), BigInteger.valueOf(1L));
    }

    @Override
    public Generic[] sumValue() {
        try {
            if (this.integerValue().signum() == 0) {
                return new Generic[0];
            }
            return new Generic[]{this};
        }
        catch (NotIntegerException e) {
            return new Generic[]{this};
        }
    }

    @Override
    public Generic[] productValue() throws NotProductException {
        try {
            if (this.integerValue().compareTo(JSCLInteger.valueOf(1L)) == 0) {
                return new Generic[0];
            }
            return new Generic[]{this};
        }
        catch (NotIntegerException e) {
            return new Generic[]{this};
        }
    }

    @Override
    public Power powerValue() throws NotPowerException {
        return new Power(this, 1);
    }

    @Override
    public Expression expressionValue() throws NotExpressionException {
        return Expression.valueOf(this);
    }

    @Override
    public JSCLInteger integerValue() throws NotIntegerException {
        if (this.denominator.compareTo(BigInteger.valueOf(1L)) == 0) {
            return new JSCLInteger(this.numerator);
        }
        throw new NotIntegerException();
    }

    @Override
    public Variable variableValue() throws NotVariableException {
        try {
            this.integerValue();
            throw new NotVariableException();
        }
        catch (NotIntegerException e) {
            if (this.numerator.compareTo(BigInteger.valueOf(1L)) == 0) {
                return new Inv(new JSCLInteger(this.denominator));
            }
            return new Frac(new JSCLInteger(this.numerator), new JSCLInteger(this.denominator));
        }
    }

    @Override
    public Variable[] variables() {
        return new Variable[0];
    }

    @Override
    public boolean isPolynomial(Variable variable) {
        return true;
    }

    @Override
    public boolean isConstant(Variable variable) {
        return true;
    }

    public int compareTo(Rational rational) {
        int c = this.denominator.compareTo(rational.denominator);
        if (c < 0) {
            return -1;
        }
        if (c > 0) {
            return 1;
        }
        return this.numerator.compareTo(rational.numerator);
    }

    @Override
    public int compareTo(Generic generic) {
        if (generic instanceof Rational) {
            return this.compareTo((Rational)generic);
        }
        if (generic instanceof JSCLInteger) {
            return this.compareTo(this.valueof(generic));
        }
        return generic.valueof(this).compareTo(generic);
    }

    public String toString() {
        StringBuffer buffer = new StringBuffer();
        try {
            buffer.append(this.integerValue());
        }
        catch (NotIntegerException e) {
            buffer.append(this.numerator);
            buffer.append("/");
            buffer.append(this.denominator);
        }
        return buffer.toString();
    }

    @Override
    public String toJava() {
        return "JSCLDouble.valueOf(" + this.numerator + "/" + this.denominator + ")";
    }

    @Override
    public void toMathML(MathML element, Object data) {
        int exponent;
        int n = exponent = data instanceof Integer ? (Integer)data : 1;
        if (exponent == 1) {
            this.bodyToMathML(element);
        } else {
            MathML e1 = element.element("msup");
            this.bodyToMathML(e1);
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(exponent)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }

    void bodyToMathML(MathML element) {
        try {
            MathML e1 = element.element("mn");
            e1.appendChild(element.text(String.valueOf(this.integerValue())));
            element.appendChild(e1);
        }
        catch (NotIntegerException e) {
            MathML e1 = element.element("mfrac");
            MathML e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(this.numerator)));
            e1.appendChild(e2);
            e2 = element.element("mn");
            e2.appendChild(element.text(String.valueOf(this.denominator)));
            e1.appendChild(e2);
            element.appendChild(e1);
        }
    }
}

