/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.xmlparser;

import java.io.IOException;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerException;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.queryParser.QueryParser;
import org.apache.lucene.search.Hits;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.store.Directory;
import org.apache.lucene.store.RAMDirectory;
import org.apache.lucene.xmlparser.CoreParser;
import org.apache.lucene.xmlparser.CorePlusExtensionsParser;
import org.apache.lucene.xmlparser.ParserException;
import org.apache.lucene.xmlparser.QueryTemplateManager;
import org.w3c.dom.Document;
import org.xml.sax.SAXException;

public class TestQueryTemplateManager
extends TestCase {
    CoreParser builder;
    Analyzer analyzer = new StandardAnalyzer();
    private IndexSearcher searcher;
    String[] docFieldValues = new String[]{"artist=Jeff Buckley \talbum=Grace \treleaseDate=1999 \tgenre=rock", "artist=Fugazi \talbum=Repeater \treleaseDate=1990 \tgenre=alternative", "artist=Fugazi \talbum=Red Medicine \treleaseDate=1995 \tgenre=alternative", "artist=Peeping Tom \talbum=Peeping Tom \treleaseDate=2006 \tgenre=rock", "artist=Red Snapper \talbum=Prince Blimey \treleaseDate=1996 \tgenre=electronic"};
    String[] queryForms = new String[]{"artist=Fugazi \texpectedMatches=2 \ttemplate=albumBooleanQuery", "artist=Fugazi \treleaseDate=1990 \texpectedMatches=1 \ttemplate=albumBooleanQuery", "artist=Buckley \tgenre=rock \texpectedMatches=1 \ttemplate=albumFilteredQuery", "artist=Buckley \tgenre=electronic \texpectedMatches=0 \ttemplate=albumFilteredQuery", "queryString=artist:buckly~ NOT genre:electronic \texpectedMatches=1 \ttemplate=albumLuceneClassicQuery"};

    public void testFormTransforms() throws SAXException, IOException, ParserConfigurationException, TransformerException, ParserException {
        QueryTemplateManager qtm = new QueryTemplateManager();
        qtm.addQueryTemplate("albumBooleanQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumBooleanQuery.xsl"));
        qtm.addQueryTemplate("albumFilteredQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumFilteredQuery.xsl"));
        qtm.addQueryTemplate("albumLuceneClassicQuery", ((Object)((Object)this)).getClass().getResourceAsStream("albumLuceneClassicQuery.xsl"));
        for (int i = 0; i < this.queryForms.length; ++i) {
            Properties queryFormProperties = this.getPropsFromString(this.queryForms[i]);
            Document doc = qtm.getQueryAsDOM(queryFormProperties, queryFormProperties.getProperty("template"));
            Query q = this.builder.getQuery(doc.getDocumentElement());
            Hits h = this.searcher.search(q);
            int expectedHits = Integer.parseInt(queryFormProperties.getProperty("expectedMatches"));
            TestQueryTemplateManager.assertEquals((String)("Number of results should match for query " + this.queryForms[i]), (int)expectedHits, (int)h.length());
        }
    }

    Properties getPropsFromString(String nameValuePairs) {
        Properties result = new Properties();
        StringTokenizer st = new StringTokenizer(nameValuePairs, "\t=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken().trim();
            result.setProperty(name, value);
        }
        return result;
    }

    org.apache.lucene.document.Document getDocumentFromString(String nameValuePairs) {
        org.apache.lucene.document.Document result = new org.apache.lucene.document.Document();
        StringTokenizer st = new StringTokenizer(nameValuePairs, "\t=");
        while (st.hasMoreTokens()) {
            String name = st.nextToken().trim();
            if (!st.hasMoreTokens()) continue;
            String value = st.nextToken().trim();
            result.add(new Field(name, value, Field.Store.YES, Field.Index.TOKENIZED));
        }
        return result;
    }

    protected void setUp() throws Exception {
        super.setUp();
        RAMDirectory dir = new RAMDirectory();
        IndexWriter w = new IndexWriter((Directory)dir, this.analyzer, true);
        for (int i = 0; i < this.docFieldValues.length; ++i) {
            w.addDocument(this.getDocumentFromString(this.docFieldValues[i]));
        }
        w.optimize();
        w.close();
        this.searcher = new IndexSearcher(dir);
        this.builder = new CorePlusExtensionsParser(this.analyzer, new QueryParser("artist", this.analyzer));
    }

    protected void tearDown() throws Exception {
        this.searcher.close();
    }
}

