/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wordnet;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.lucene.analysis.Analyzer;
import org.apache.lucene.analysis.standard.StandardAnalyzer;
import org.apache.lucene.document.Document;
import org.apache.lucene.document.Field;
import org.apache.lucene.index.IndexWriter;

public class Syns2Index {
    private static final PrintStream o = System.out;
    private static final PrintStream err = System.err;
    public static final String F_SYN = "syn";
    public static final String F_WORD = "word";
    private static final Analyzer ana = new StandardAnalyzer();

    public static void main(String[] args) throws Throwable {
        String line;
        String prologFilename = null;
        String indexDir = null;
        if (args.length == 2) {
            prologFilename = args[0];
            indexDir = args[1];
        } else {
            Syns2Index.usage();
            System.exit(1);
        }
        if (!new File(prologFilename).canRead()) {
            err.println("Error: cannot read Prolog file: " + prologFilename);
            System.exit(1);
        }
        if (new File(indexDir).isDirectory()) {
            err.println("Error: index directory already exists: " + indexDir);
            err.println("Please specify a name of a non-existent directory");
            System.exit(1);
        }
        o.println("Opening Prolog file " + prologFilename);
        FileInputStream fis = new FileInputStream(prologFilename);
        BufferedReader br = new BufferedReader(new InputStreamReader(fis));
        TreeMap<String, List<String>> word2Nums = new TreeMap<String, List<String>>();
        TreeMap<String, List<String>> num2Words = new TreeMap<String, List<String>>();
        int ndecent = 0;
        int mod = 1;
        int row = 1;
        o.println("[1/2] Parsing " + prologFilename);
        while ((line = br.readLine()) != null) {
            int q2;
            if (++row % mod == 0) {
                mod *= 2;
                o.println("\t" + row + " " + line + " " + word2Nums.size() + " " + num2Words.size() + " ndecent=" + ndecent);
            }
            if (!line.startsWith("s(")) {
                err.println("OUCH: " + line);
                System.exit(1);
            }
            line = line.substring(2);
            int comma = line.indexOf(44);
            String num = line.substring(0, comma);
            int q1 = line.indexOf(39);
            String word = (line = line.substring(q1 + 1)).substring(0, q2 = line.indexOf(39)).toLowerCase();
            if (!Syns2Index.isDecent(word)) {
                ++ndecent;
                continue;
            }
            List<String> lis = (LinkedList<String>)word2Nums.get(word);
            if (lis == null) {
                lis = new LinkedList<String>();
                lis.add(num);
                word2Nums.put(word, lis);
            } else {
                lis.add(num);
            }
            lis = (List)num2Words.get(num);
            if (lis == null) {
                lis = new LinkedList();
                lis.add(word);
                num2Words.put(num, lis);
                continue;
            }
            lis.add(word);
        }
        fis.close();
        br.close();
        o.println("[2/2] Building index to store synonyms,  map sizes are " + word2Nums.size() + " and " + num2Words.size());
        Syns2Index.index(indexDir, word2Nums, num2Words);
    }

    private static boolean isDecent(String s) {
        int len = s.length();
        for (int i = 0; i < len; ++i) {
            if (Character.isLetter(s.charAt(i))) continue;
            return false;
        }
        return true;
    }

    private static void index(String indexDir, Map word2Nums, Map num2Words) throws Throwable {
        int row = 0;
        int mod = 1;
        IndexWriter writer = new IndexWriter(indexDir, ana, true);
        writer.setUseCompoundFile(true);
        writer.setMergeFactor(writer.getMergeFactor() * 2);
        writer.setMaxBufferedDocs(writer.getMaxBufferedDocs() * 2);
        for (String g : word2Nums.keySet()) {
            Document doc;
            int n = Syns2Index.index(word2Nums, num2Words, g, doc = new Document());
            if (n <= 0) continue;
            doc.add(new Field(F_WORD, g, Field.Store.YES, Field.Index.UN_TOKENIZED));
            if (++row % mod == 0) {
                o.println("\trow=" + row + "/" + word2Nums.size() + " doc= " + doc);
                mod *= 2;
            }
            writer.addDocument(doc);
        }
        o.println("Optimizing..");
        writer.optimize();
        writer.close();
    }

    private static int index(Map word2Nums, Map num2Words, String g, Document doc) throws Throwable {
        List keys = (List)word2Nums.get(g);
        Iterator i2 = keys.iterator();
        TreeSet already = new TreeSet();
        while (i2.hasNext()) {
            already.addAll((List)num2Words.get(i2.next()));
        }
        int num = 0;
        already.remove(g);
        for (String cur : already) {
            if (!Syns2Index.isDecent(cur)) continue;
            ++num;
            doc.add(new Field(F_SYN, cur, Field.Store.YES, Field.Index.NO));
        }
        return num;
    }

    private static void usage() {
        o.println("\n\njava org.apache.lucene.wordnet.Syns2Index <prolog file> <index dir>\n\n");
    }
}

