/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.wikipedia.analysis;

import java.io.StringReader;
import java.util.HashMap;
import junit.framework.TestCase;
import org.apache.lucene.analysis.Token;
import org.apache.lucene.wikipedia.analysis.WikipediaTokenizer;

public class WikipediaTokenizerTest
extends TestCase {
    public WikipediaTokenizerTest(String s) {
        super(s);
    }

    protected void setUp() {
    }

    protected void tearDown() {
    }

    public void testHandwritten() throws Exception {
        String test = "[[link]] This is a [[Category:foo]] Category  This is a linked [[:Category:bar none withstanding]] Category This is (parens) This is a [[link]]  This is an external URL [http://lucene.apache.org] Here is ''italics'' and ''more italics'', '''bold''' and '''''five quotes'''''  This is a [[link|display info]]  This is a period.  Here is $3.25 and here is 3.50.  Here's Johnny.  ==heading== ===sub head=== followed by some text  [[Category:blah| ]] ''[[Category:ital_cat]]''  here is some that is ''italics [[Category:foo]] but is never closed.'''same [[Category:foo]] goes for this '''''and2 [[Category:foo]] and this [http://foo.boo.com/test/test/ Test Test] [http://foo.boo.com/test/test/test.html Test Test] [http://foo.boo.com/test/test/test.html?g=b&c=d Test Test] <ref>Citation</ref> <sup>martian</sup> <span class=\"glue\">code</span>";
        HashMap<String, String> tcm = new HashMap<String, String>();
        tcm.put("link", "il");
        tcm.put("display", "il");
        tcm.put("info", "il");
        tcm.put("http://lucene.apache.org", "elu");
        tcm.put("http://foo.boo.com/test/test/", "elu");
        tcm.put("http://foo.boo.com/test/test/test.html", "elu");
        tcm.put("http://foo.boo.com/test/test/test.html?g=b&c=d", "elu");
        tcm.put("Test", "el");
        tcm.put("This", "<ALPHANUM>");
        tcm.put("is", "<ALPHANUM>");
        tcm.put("a", "<ALPHANUM>");
        tcm.put("Category", "<ALPHANUM>");
        tcm.put("linked", "<ALPHANUM>");
        tcm.put("parens", "<ALPHANUM>");
        tcm.put("external", "<ALPHANUM>");
        tcm.put("URL", "<ALPHANUM>");
        tcm.put("and", "<ALPHANUM>");
        tcm.put("period", "<ALPHANUM>");
        tcm.put("Here", "<ALPHANUM>");
        tcm.put("Here's", "<APOSTROPHE>");
        tcm.put("here", "<ALPHANUM>");
        tcm.put("Johnny", "<ALPHANUM>");
        tcm.put("followed", "<ALPHANUM>");
        tcm.put("by", "<ALPHANUM>");
        tcm.put("text", "<ALPHANUM>");
        tcm.put("that", "<ALPHANUM>");
        tcm.put("but", "<ALPHANUM>");
        tcm.put("never", "<ALPHANUM>");
        tcm.put("closed", "<ALPHANUM>");
        tcm.put("goes", "<ALPHANUM>");
        tcm.put("for", "<ALPHANUM>");
        tcm.put("this", "<ALPHANUM>");
        tcm.put("an", "<ALPHANUM>");
        tcm.put("some", "<ALPHANUM>");
        tcm.put("martian", "<ALPHANUM>");
        tcm.put("code", "<ALPHANUM>");
        tcm.put("foo", "c");
        tcm.put("bar", "c");
        tcm.put("none", "c");
        tcm.put("withstanding", "c");
        tcm.put("blah", "c");
        tcm.put("ital", "c");
        tcm.put("cat", "c");
        tcm.put("italics", "i");
        tcm.put("more", "i");
        tcm.put("bold", "b");
        tcm.put("same", "b");
        tcm.put("five", "bi");
        tcm.put("and2", "bi");
        tcm.put("quotes", "bi");
        tcm.put("heading", "h");
        tcm.put("sub", "sh");
        tcm.put("head", "sh");
        tcm.put("Citation", "ci");
        tcm.put("3.25", "<NUM>");
        tcm.put("3.50", "<NUM>");
        WikipediaTokenizer tf = new WikipediaTokenizer(new StringReader(test));
        Token token = new Token();
        int count = 0;
        int numItalics = 0;
        int numBoldItalics = 0;
        int numCategory = 0;
        int numCitation = 0;
        while ((token = tf.next(token)) != null) {
            String tokText = token.termText();
            WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
            String expectedType = (String)tcm.get(tokText);
            WikipediaTokenizerTest.assertTrue((String)("expectedType is null and it shouldn't be for: " + token), (expectedType != null ? 1 : 0) != 0);
            WikipediaTokenizerTest.assertTrue((String)(token.type() + " is not equal to " + expectedType + " for " + token), (token.type().equals(expectedType) ? 1 : 0) != 0);
            ++count;
            if (token.type().equals("i")) {
                ++numItalics;
                continue;
            }
            if (token.type().equals("bi")) {
                ++numBoldItalics;
                continue;
            }
            if (token.type().equals("c")) {
                ++numCategory;
                continue;
            }
            if (!token.type().equals("ci")) continue;
            ++numCitation;
        }
        WikipediaTokenizerTest.assertTrue((String)("We have not seen enough tokens: " + count + " is not >= " + tcm.size()), (count >= tcm.size() ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(numItalics + " does not equal: " + 4 + " for numItalics"), (numItalics == 4 ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(numBoldItalics + " does not equal: " + 3 + " for numBoldItalics"), (numBoldItalics == 3 ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(numCategory + " does not equal: " + 10 + " for numCategory"), (numCategory == 10 ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(numCitation + " does not equal: " + 1 + " for numCitation"), (numCitation == 1 ? 1 : 0) != 0);
    }

    public void testLinkPhrases() throws Exception {
        String test = "click [[link here again]] click [http://lucene.apache.org here again]";
        WikipediaTokenizer tf = new WikipediaTokenizer(new StringReader(test));
        Token token = new Token();
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", ((token = tf.next(token)) != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to click"), (new String(token.termBuffer(), 0, token.termLength()).equals("click") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to link"), (new String(token.termBuffer(), 0, token.termLength()).equals("link") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to here"), (new String(token.termBuffer(), 0, token.termLength()).equals("here") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to again"), (new String(token.termBuffer(), 0, token.termLength()).equals("again") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to click"), (new String(token.termBuffer(), 0, token.termLength()).equals("click") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to http://lucene.apache.org"), (new String(token.termBuffer(), 0, token.termLength()).equals("http://lucene.apache.org") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to here"), (new String(token.termBuffer(), 0, token.termLength()).equals("here") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 0), (token.getPositionIncrement() == 0 ? 1 : 0) != 0);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to again"), (new String(token.termBuffer(), 0, token.termLength()).equals("again") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.getPositionIncrement() + " does not equal: " + 1), (token.getPositionIncrement() == 1 ? 1 : 0) != 0);
    }

    public void testLinks() throws Exception {
        String test = "[http://lucene.apache.org/java/docs/index.html#news here] [http://lucene.apache.org/java/docs/index.html?b=c here] [https://lucene.apache.org/java/docs/index.html?b=c here]";
        WikipediaTokenizer tf = new WikipediaTokenizer(new StringReader(test));
        Token token = new Token();
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", ((token = tf.next(token)) != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to http://lucene.apache.org/java/docs/index.html#news"), (new String(token.termBuffer(), 0, token.termLength()).equals("http://lucene.apache.org/java/docs/index.html#news") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.type() + " is not equal to " + "elu"), (token.type().equals("elu") ? 1 : 0) != 0);
        tf.next(token);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to http://lucene.apache.org/java/docs/index.html?b=c"), (new String(token.termBuffer(), 0, token.termLength()).equals("http://lucene.apache.org/java/docs/index.html?b=c") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.type() + " is not equal to " + "elu"), (token.type().equals("elu") ? 1 : 0) != 0);
        tf.next(token);
        token = tf.next(token);
        WikipediaTokenizerTest.assertTrue((String)"token is null and it shouldn't be", (token != null ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(new String(token.termBuffer(), 0, token.termLength()) + " is not equal to https://lucene.apache.org/java/docs/index.html?b=c"), (new String(token.termBuffer(), 0, token.termLength()).equals("https://lucene.apache.org/java/docs/index.html?b=c") ? 1 : 0) != 0);
        WikipediaTokenizerTest.assertTrue((String)(token.type() + " is not equal to " + "elu"), (token.type().equals("elu") ? 1 : 0) != 0);
    }
}

